/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Protocol {
    public static final StructType FULL_SCHEMA = new StructType().add("minReaderVersion", (DataType)IntegerType.INTEGER, false).add("minWriterVersion", (DataType)IntegerType.INTEGER, false).add("readerFeatures", new ArrayType(StringType.STRING, false)).add("writerFeatures", new ArrayType(StringType.STRING, false));
    private final int minReaderVersion;
    private final int minWriterVersion;
    private final List<String> readerFeatures;
    private final List<String> writerFeatures;

    public static Protocol fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        return new Protocol(columnVector.getChild(0).getInt(n), columnVector.getChild(1).getInt(n), columnVector.getChild(2).isNullAt(n) ? Collections.emptyList() : VectorUtils.toJavaList(columnVector.getChild(2).getArray(n)), columnVector.getChild(3).isNullAt(n) ? Collections.emptyList() : VectorUtils.toJavaList(columnVector.getChild(3).getArray(n)));
    }

    public Protocol(int n, int n2, List<String> list, List<String> list2) {
        this.minReaderVersion = n;
        this.minWriterVersion = n2;
        this.readerFeatures = list;
        this.writerFeatures = list2;
    }

    public int getMinReaderVersion() {
        return this.minReaderVersion;
    }

    public int getMinWriterVersion() {
        return this.minWriterVersion;
    }

    public List<String> getReaderFeatures() {
        return this.readerFeatures;
    }

    public List<String> getWriterFeatures() {
        return this.writerFeatures;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Protocol{");
        stringBuilder.append("minReaderVersion=").append(this.minReaderVersion);
        stringBuilder.append(", minWriterVersion=").append(this.minWriterVersion);
        stringBuilder.append(", readerFeatures=").append(this.readerFeatures);
        stringBuilder.append(", writerFeatures=").append(this.writerFeatures);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.minReaderVersion);
        hashMap.put(1, this.minWriterVersion);
        hashMap.put(2, VectorUtils.stringArrayValue(this.readerFeatures));
        hashMap.put(3, VectorUtils.stringArrayValue(this.writerFeatures));
        return new GenericRow(FULL_SCHEMA, hashMap);
    }
}

