/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CommitInfo {
    public static StructType FULL_SCHEMA = new StructType().add("timestamp", LongType.LONG).add("engineInfo", StringType.STRING).add("operation", StringType.STRING).add("operationParameters", new MapType(StringType.STRING, StringType.STRING, true)).add("isBlindAppend", (DataType)BooleanType.BOOLEAN, true).add("txnId", StringType.STRING);
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL = IntStream.range(0, FULL_SCHEMA.length()).boxed().collect(Collectors.toMap(n -> FULL_SCHEMA.at((int)n).getName(), n -> n));
    private final long timestamp;
    private final String engineInfo;
    private final String operation;
    private final Map<String, String> operationParameters;
    private final boolean isBlindAppend;
    private final String txnId;

    public CommitInfo(long l, String string, String string2, Map<String, String> map, boolean bl, String string3) {
        this.timestamp = l;
        this.engineInfo = string;
        this.operation = string2;
        this.operationParameters = Collections.unmodifiableMap(map);
        this.isBlindAppend = bl;
        this.txnId = string3;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEngineInfo() {
        return this.engineInfo;
    }

    public String getOperation() {
        return this.operation;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COL_NAME_TO_ORDINAL.get("timestamp"), this.timestamp);
        hashMap.put(COL_NAME_TO_ORDINAL.get("engineInfo"), this.engineInfo);
        hashMap.put(COL_NAME_TO_ORDINAL.get("operation"), this.operation);
        hashMap.put(COL_NAME_TO_ORDINAL.get("operationParameters"), VectorUtils.stringStringMapValue(this.operationParameters));
        hashMap.put(COL_NAME_TO_ORDINAL.get("isBlindAppend"), this.isBlindAppend);
        hashMap.put(COL_NAME_TO_ORDINAL.get("txnId"), this.txnId);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }
}

