/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Snapshot;
import io.delta.kernel.Table;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.TransactionBuilderImpl;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.snapshot.SnapshotManager;
import java.io.IOException;

public class TableImpl
implements Table {
    private final SnapshotManager snapshotManager;
    private final String tablePath;

    public static Table forPath(Engine engine, String string) {
        String string2;
        try {
            string2 = engine.getFileSystemClient().resolvePath(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return new TableImpl(string2);
    }

    public TableImpl(String string) {
        this.tablePath = string;
        Path path = new Path(string);
        Path path2 = new Path(path, "_delta_log");
        this.snapshotManager = new SnapshotManager(path2, path);
    }

    @Override
    public String getPath(Engine engine) {
        return this.tablePath;
    }

    @Override
    public Snapshot getLatestSnapshot(Engine engine) throws TableNotFoundException {
        return this.snapshotManager.buildLatestSnapshot(engine);
    }

    @Override
    public Snapshot getSnapshotAsOfVersion(Engine engine, long l) throws TableNotFoundException {
        return this.snapshotManager.getSnapshotAt(engine, l);
    }

    @Override
    public Snapshot getSnapshotAsOfTimestamp(Engine engine, long l) throws TableNotFoundException {
        return this.snapshotManager.getSnapshotForTimestamp(engine, l);
    }

    @Override
    public void checkpoint(Engine engine, long l) throws TableNotFoundException, CheckpointAlreadyExistsException, IOException {
        this.snapshotManager.checkpoint(engine, l);
    }

    @Override
    public TransactionBuilder createTransactionBuilder(Engine engine, String string, Operation operation) {
        return new TransactionBuilderImpl(this, string, operation);
    }

    protected Path getDataPath() {
        return new Path(this.tablePath);
    }

    protected Path getLogPath() {
        return new Path(this.tablePath, "_delta_log");
    }
}

