
package io.cucumber.messages.types;

import java.util.HashMap;
import java.util.Map;

public class TestStepResult {

    /**
     * The structure is pretty close of the Timestamp one. For clarity, a second type
     *  of message is used.
     * (Required)
     * 
     */
    private Duration duration;
    private String message;
    /**
     * 
     * (Required)
     * 
     */
    private TestStepResult.Status status;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestStepResult() {
    }

    /**
     * 
     * @param duration
     * @param message
     * @param status
     */
    public TestStepResult(Duration duration, String message, TestStepResult.Status status) {
        super();
        this.duration = duration;
        this.message = message;
        this.status = status;
    }

    /**
     * The structure is pretty close of the Timestamp one. For clarity, a second type
     *  of message is used.
     * (Required)
     * 
     */
    public Duration getDuration() {
        return duration;
    }

    /**
     * The structure is pretty close of the Timestamp one. For clarity, a second type
     *  of message is used.
     * (Required)
     * 
     */
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 
     * (Required)
     * 
     */
    public TestStepResult.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setStatus(TestStepResult.Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestStepResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("duration");
        sb.append('=');
        sb.append(((this.duration == null)?"<null>":this.duration));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.duration == null)? 0 :this.duration.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestStepResult) == false) {
            return false;
        }
        TestStepResult rhs = ((TestStepResult) other);
        return ((((this.duration == rhs.duration)||((this.duration!= null)&&this.duration.equals(rhs.duration)))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    public enum Status {

        UNKNOWN("UNKNOWN"),
        PASSED("PASSED"),
        SKIPPED("SKIPPED"),
        PENDING("PENDING"),
        UNDEFINED("UNDEFINED"),
        AMBIGUOUS("AMBIGUOUS"),
        FAILED("FAILED");
        private final String value;
        private final static Map<String, TestStepResult.Status> CONSTANTS = new HashMap<String, TestStepResult.Status>();

        static {
            for (TestStepResult.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static TestStepResult.Status fromValue(String value) {
            TestStepResult.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
