
package io.cucumber.messages.types;


public class StepDefinition {

    /**
     * 
     * (Required)
     * 
     */
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    private StepDefinitionPattern pattern;
    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    private SourceReference sourceReference;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StepDefinition() {
    }

    /**
     * 
     * @param sourceReference
     * @param pattern
     * @param id
     */
    public StepDefinition(String id, StepDefinitionPattern pattern, SourceReference sourceReference) {
        super();
        this.id = id;
        this.pattern = pattern;
        this.sourceReference = sourceReference;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public StepDefinitionPattern getPattern() {
        return pattern;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setPattern(StepDefinitionPattern pattern) {
        this.pattern = pattern;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public SourceReference getSourceReference() {
        return sourceReference;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public void setSourceReference(SourceReference sourceReference) {
        this.sourceReference = sourceReference;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StepDefinition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("pattern");
        sb.append('=');
        sb.append(((this.pattern == null)?"<null>":this.pattern));
        sb.append(',');
        sb.append("sourceReference");
        sb.append('=');
        sb.append(((this.sourceReference == null)?"<null>":this.sourceReference));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.pattern == null)? 0 :this.pattern.hashCode()));
        result = ((result* 31)+((this.sourceReference == null)? 0 :this.sourceReference.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StepDefinition) == false) {
            return false;
        }
        StepDefinition rhs = ((StepDefinition) other);
        return ((((this.pattern == rhs.pattern)||((this.pattern!= null)&&this.pattern.equals(rhs.pattern)))&&((this.sourceReference == rhs.sourceReference)||((this.sourceReference!= null)&&this.sourceReference.equals(rhs.sourceReference))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))));
    }

}
