
package io.cucumber.messages.types;



/**
 * *
 *  A child node of a `Rule` node
 * 
 */
public class RuleChild {

    private Background background;
    private Scenario scenario;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RuleChild() {
    }

    /**
     * 
     * @param scenario
     * @param background
     */
    public RuleChild(Background background, Scenario scenario) {
        super();
        this.background = background;
        this.scenario = scenario;
    }

    public Background getBackground() {
        return background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public Scenario getScenario() {
        return scenario;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RuleChild.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("background");
        sb.append('=');
        sb.append(((this.background == null)?"<null>":this.background));
        sb.append(',');
        sb.append("scenario");
        sb.append('=');
        sb.append(((this.scenario == null)?"<null>":this.scenario));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.scenario == null)? 0 :this.scenario.hashCode()));
        result = ((result* 31)+((this.background == null)? 0 :this.background.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RuleChild) == false) {
            return false;
        }
        RuleChild rhs = ((RuleChild) other);
        return (((this.scenario == rhs.scenario)||((this.scenario!= null)&&this.scenario.equals(rhs.scenario)))&&((this.background == rhs.background)||((this.background!= null)&&this.background.equals(rhs.background))));
    }

}
