
package io.cucumber.messages.types;


public class ParseError {

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    private SourceReference source;
    /**
     * 
     * (Required)
     * 
     */
    private String message;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParseError() {
    }

    /**
     * 
     * @param source
     * @param message
     */
    public ParseError(SourceReference source, String message) {
        super();
        this.source = source;
        this.message = message;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public SourceReference getSource() {
        return source;
    }

    /**
     * *
     *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
     *  [Location](#io.cucumber.messages.Location) within that file.
     * (Required)
     * 
     */
    public void setSource(SourceReference source) {
        this.source = source;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getMessage() {
        return message;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ParseError.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ParseError) == false) {
            return false;
        }
        ParseError rhs = ((ParseError) other);
        return (((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message)))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))));
    }

}
