
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class JavaMethod {

    /**
     * 
     * (Required)
     * 
     */
    private String className;
    /**
     * 
     * (Required)
     * 
     */
    private String methodName;
    /**
     * 
     * (Required)
     * 
     */
    private List<String> methodParameterTypes = new ArrayList<String>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public JavaMethod() {
    }

    /**
     * 
     * @param methodName
     * @param className
     * @param methodParameterTypes
     */
    public JavaMethod(String className, String methodName, List<String> methodParameterTypes) {
        super();
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getClassName() {
        return className;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setClassName(String className) {
        this.className = className;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getMethodName() {
        return methodName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<String> getMethodParameterTypes() {
        return methodParameterTypes;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setMethodParameterTypes(List<String> methodParameterTypes) {
        this.methodParameterTypes = methodParameterTypes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaMethod.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("className");
        sb.append('=');
        sb.append(((this.className == null)?"<null>":this.className));
        sb.append(',');
        sb.append("methodName");
        sb.append('=');
        sb.append(((this.methodName == null)?"<null>":this.methodName));
        sb.append(',');
        sb.append("methodParameterTypes");
        sb.append('=');
        sb.append(((this.methodParameterTypes == null)?"<null>":this.methodParameterTypes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.methodName == null)? 0 :this.methodName.hashCode()));
        result = ((result* 31)+((this.className == null)? 0 :this.className.hashCode()));
        result = ((result* 31)+((this.methodParameterTypes == null)? 0 :this.methodParameterTypes.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JavaMethod) == false) {
            return false;
        }
        JavaMethod rhs = ((JavaMethod) other);
        return ((((this.methodName == rhs.methodName)||((this.methodName!= null)&&this.methodName.equals(rhs.methodName)))&&((this.className == rhs.className)||((this.className!= null)&&this.className.equals(rhs.className))))&&((this.methodParameterTypes == rhs.methodParameterTypes)||((this.methodParameterTypes!= null)&&this.methodParameterTypes.equals(rhs.methodParameterTypes))));
    }

}
