
package io.cucumber.messages.types;



/**
 * The structure is pretty close of the Timestamp one. For clarity, a second type
 *  of message is used.
 * 
 */
public class Duration {

    /**
     * 
     * (Required)
     * 
     */
    private Long seconds;
    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    private Long nanos;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Duration() {
    }

    /**
     * 
     * @param seconds
     * @param nanos
     */
    public Duration(Long seconds, Long nanos) {
        super();
        this.seconds = seconds;
        this.nanos = nanos;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getSeconds() {
        return seconds;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setSeconds(Long seconds) {
        this.seconds = seconds;
    }

    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    public Long getNanos() {
        return nanos;
    }

    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    public void setNanos(Long nanos) {
        this.nanos = nanos;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Duration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("seconds");
        sb.append('=');
        sb.append(((this.seconds == null)?"<null>":this.seconds));
        sb.append(',');
        sb.append("nanos");
        sb.append('=');
        sb.append(((this.nanos == null)?"<null>":this.nanos));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.nanos == null)? 0 :this.nanos.hashCode()));
        result = ((result* 31)+((this.seconds == null)? 0 :this.seconds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Duration) == false) {
            return false;
        }
        Duration rhs = ((Duration) other);
        return (((this.nanos == rhs.nanos)||((this.nanos!= null)&&this.nanos.equals(rhs.nanos)))&&((this.seconds == rhs.seconds)||((this.seconds!= null)&&this.seconds.equals(rhs.seconds))));
    }

}
