/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.groovy;

import cucumber.runtime.CucumberException;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.TagExpression;
import groovy.lang.Closure;
import java.util.ArrayList;

public class Hooks {
    private static final int DEFAULT_ORDER = 10000;
    private static final long DEFAULT_TIMEOUT = 0L;

    public static void World(Closure body) throws Throwable {
        GroovyBackend.getInstance().registerWorld(body);
    }

    public static void Before(Object ... args) {
        Hooks.addHook(args, true);
    }

    public static void After(Object ... args) {
        Hooks.addHook(args, false);
    }

    private static void addHook(Object[] tagsExpressionsAndBody, boolean before) {
        long timeoutMillis = 0L;
        int order = 10000;
        boolean timeoutSet = false;
        boolean orderSet = false;
        Closure body = null;
        ArrayList<String> tagExpressions = new ArrayList<String>();
        for (Object o : tagsExpressionsAndBody) {
            if (o instanceof String) {
                tagExpressions.add((String)o);
                continue;
            }
            if (o instanceof Long) {
                if (timeoutSet) {
                    throw new CucumberException("Two timeout (Long) arguments found; " + Long.toString(timeoutMillis) + ", and; " + Long.toString((Long)o));
                }
                timeoutMillis = (Long)o;
                timeoutSet = true;
                continue;
            }
            if (o instanceof Integer) {
                if (orderSet) {
                    throw new CucumberException("Two order (Integer) arguments found; " + Integer.toString(order) + ", and; " + Integer.toString((Integer)o));
                }
                order = (Integer)o;
                orderSet = true;
                continue;
            }
            if (o instanceof Closure) {
                body = (Closure)o;
                continue;
            }
            throw new CucumberException("An argument of the type " + o.getClass().getName() + " found, " + (before ? "Before" : "After") + " only allows the argument types String - Tag, Long - timeout, Integer - order, and Closure");
        }
        TagExpression tagExpression = new TagExpression(tagExpressions);
        if (before) {
            GroovyBackend.getInstance().addBeforeHook(tagExpression, timeoutMillis, order, body);
        } else {
            GroovyBackend.getInstance().addAfterHook(tagExpression, timeoutMillis, order, body);
        }
    }
}

