/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CombinatorialGeneratedExpressionFactory;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeMatcher;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CucumberExpressionGenerator {
    private final ParameterTypeRegistry parameterTypeRegistry;

    public CucumberExpressionGenerator(ParameterTypeRegistry parameterTypeRegistry) {
        this.parameterTypeRegistry = parameterTypeRegistry;
    }

    public List<GeneratedExpression> generateExpressions(String text) {
        ParameterTypeMatcher bestParameterTypeMatcher;
        ArrayList parameterTypeCombinations = new ArrayList();
        List<ParameterTypeMatcher> parameterTypeMatchers = this.createParameterTypeMatchers(text);
        StringBuilder expressionTemplate = new StringBuilder();
        int pos = 0;
        do {
            ArrayList<ParameterTypeMatcher> matchingParameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
            for (ParameterTypeMatcher parameterTypeMatcher : parameterTypeMatchers) {
                if (!parameterTypeMatcher.advanceToAndFind(pos)) continue;
                matchingParameterTypeMatchers.add(parameterTypeMatcher);
            }
            if (matchingParameterTypeMatchers.isEmpty()) break;
            Collections.sort(matchingParameterTypeMatchers);
            bestParameterTypeMatcher = (ParameterTypeMatcher)matchingParameterTypeMatchers.get(0);
            ArrayList<ParameterTypeMatcher> bestParameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
            for (ParameterTypeMatcher parameterTypeMatcher : matchingParameterTypeMatchers) {
                if (parameterTypeMatcher.compareTo(bestParameterTypeMatcher) != 0) continue;
                bestParameterTypeMatchers.add(parameterTypeMatcher);
            }
            HashSet set = new HashSet();
            for (ParameterTypeMatcher parameterTypeMatcher : bestParameterTypeMatchers) {
                ParameterType<?> parameterType = parameterTypeMatcher.getParameterType();
                set.add(parameterType);
            }
            TreeSet treeSet = new TreeSet(set);
            parameterTypeCombinations.add(new ArrayList(treeSet));
            expressionTemplate.append(this.escape(text.substring(pos, bestParameterTypeMatcher.start()))).append("{%s}");
        } while ((pos = bestParameterTypeMatcher.start() + bestParameterTypeMatcher.group().length()) < text.length());
        expressionTemplate.append(this.escape(text.substring(pos)));
        return new CombinatorialGeneratedExpressionFactory(expressionTemplate.toString(), parameterTypeCombinations).generateExpressions();
    }

    private String escape(String s) {
        return s.replaceAll("%", "%%").replaceAll("\\(", "\\\\(").replaceAll("\\{", "\\\\{").replaceAll("/", "\\\\/");
    }

    private List<ParameterTypeMatcher> createParameterTypeMatchers(String text) {
        Collection<ParameterType<?>> parameterTypes = this.parameterTypeRegistry.getParameterTypes();
        ArrayList<ParameterTypeMatcher> parameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
        for (ParameterType<?> parameterType : parameterTypes) {
            if (!parameterType.useForSnippets()) continue;
            parameterTypeMatchers.addAll(CucumberExpressionGenerator.createParameterTypeMatchers(parameterType, text));
        }
        return parameterTypeMatchers;
    }

    private static List<ParameterTypeMatcher> createParameterTypeMatchers(ParameterType<?> parameterType, String text) {
        ArrayList<ParameterTypeMatcher> result = new ArrayList<ParameterTypeMatcher>();
        List<String> captureGroupRegexps = parameterType.getRegexps();
        for (String captureGroupRegexp : captureGroupRegexps) {
            Pattern regexp = Pattern.compile("(" + captureGroupRegexp + ")");
            Matcher matcher = regexp.matcher(text);
            result.add(new ParameterTypeMatcher(parameterType, matcher, text));
        }
        return result;
    }
}

