/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class GroupTopicPartitionDeserializer
implements Deserializer<GroupTopicPartition> {
    private static final String ENCODING = "UTF8";

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public GroupTopicPartition deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            ByteBuffer buf = ByteBuffer.wrap(data);
            int groupIdLength = buf.getInt();
            byte[] groupIdBytes = new byte[groupIdLength];
            buf.get(groupIdBytes);
            String groupId = new String(groupIdBytes, ENCODING);
            int topicLength = buf.getInt();
            byte[] topicBytes = new byte[topicLength];
            buf.get(topicBytes);
            String otherTopic = new String(topicBytes, ENCODING);
            int partition = buf.getInt();
            return new GroupTopicPartition(groupId, otherTopic, partition);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to string");
        }
    }

    public void close() {
    }
}

