/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.ConsumerTimestampsWriter;
import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import io.confluent.connect.replicator.offsets.TimestampAndDelta;
import io.confluent.connect.replicator.util.ReplicatorAdminClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerTimestampsCommitter {
    private static final Logger log = LoggerFactory.getLogger(ConsumerTimestampsCommitter.class);
    private final String groupId;
    private final ConsumerTimestampsWriter writer;
    private final ConcurrentMap<TopicPartition, Long> timestamps = new ConcurrentHashMap<TopicPartition, Long>();

    public ConsumerTimestampsCommitter(String groupId, Map<String, ?> configs, ReplicatorAdminClient adminClient) {
        ConsumerTimestampsWriter writer = new ConsumerTimestampsWriter(adminClient);
        writer.configure(configs);
        this.groupId = groupId;
        this.writer = writer;
    }

    public ConsumerTimestampsCommitter(String groupId, ConsumerTimestampsWriter writer) {
        this.groupId = groupId;
        this.writer = writer;
    }

    protected Map<TopicPartition, Long> timestamps() {
        return this.timestamps;
    }

    public void commitRecord(SourceRecord record) {
        if (record.timestamp() == null) {
            return;
        }
        Map sourcePartition = record.sourcePartition();
        if (sourcePartition == null) {
            log.warn("Could not get source partition map from source record with destination topic {}", (Object)record.topic());
            return;
        }
        String topic = (String)sourcePartition.get("topic");
        if (topic == null) {
            log.warn("Could not get source topic from source record with destination topic {}", (Object)record.topic());
            return;
        }
        Integer partition = (Integer)sourcePartition.get("partition");
        if (partition == null) {
            log.warn("Could not get source partition from source record with destination topic {}", (Object)record.topic());
            return;
        }
        this.timestamps.put(new TopicPartition(topic, partition.intValue()), record.timestamp());
    }

    public void commit() {
        log.debug("Writing {} internal offset timestamp records", (Object)this.timestamps.size());
        for (Map.Entry entry : this.timestamps.entrySet()) {
            TopicPartition topicPartition = (TopicPartition)entry.getKey();
            TimestampAndDelta committedTimestamp = new TimestampAndDelta((Long)entry.getValue());
            GroupTopicPartition newPartition = new GroupTopicPartition(this.groupId, topicPartition);
            this.writer.send(newPartition, committedTimestamp, (metadata, error) -> {
                if (error == null) {
                    this.timestamps.remove(topicPartition, committedTimestamp.timestamp());
                }
            });
        }
    }

    public void stop() {
        this.writer.close();
    }
}

