/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class GroupTopicPartitionSerializer
implements Serializer<GroupTopicPartition> {
    private static final String ENCODING = "UTF8";
    private static final int ARRAY_LENGTH_SIZE = 4;
    private static final int PARTITION_SIZE = 4;

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, GroupTopicPartition data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] groupIdBytes = data.groupId().getBytes(ENCODING);
            byte[] topicBytes = data.topic().getBytes(ENCODING);
            ByteBuffer buf = ByteBuffer.allocate(4 + groupIdBytes.length + 4 + topicBytes.length + 4);
            buf.putInt(groupIdBytes.length);
            buf.put(groupIdBytes);
            buf.putInt(topicBytes.length);
            buf.put(topicBytes);
            buf.putInt(data.partition());
            return buf.array();
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when serializing string to byte[]");
        }
    }

    public void close() {
    }
}

