/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.events.EventEmitterConfig;
import io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.telemetry.events.exporter.kafka.EventAsyncKafkaExporter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitterImpl
implements EventEmitter,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(EventEmitterImpl.class);
    private Map<String, String> eventLabels = new HashMap<String, String>();
    private EventEmitterConfig eventEmitterConfig;
    private final Map<String, Exporter<Event>> exportersMap = new HashMap<String, Exporter<Event>>();

    public EventEmitterImpl(Map<String, ?> configs) {
        this.configure(configs);
    }

    public CompletableFuture<Boolean> emit(Event event) {
        for (String key : this.eventLabels.keySet()) {
            event.setExtension(key, this.eventLabels.get(key));
        }
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        CompletableFuture[] allResults = (CompletableFuture[])this.exportersMap.entrySet().stream().map(entry -> ((CompletableFuture)((Exporter)entry.getValue()).emit(event).exceptionally(e -> {
            log.error("Failed to emit events at exporter: {}", entry.getKey(), e);
            return false;
        })).thenApply(res -> {
            if (res.booleanValue()) {
                ret.complete(true);
            }
            return null;
        })).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(allResults).whenComplete((res, e) -> {
            ret.complete(false);
            if (e != null) {
                log.error("should never happen", e);
            }
        });
        return ret;
    }

    public void setEventLabels(Map<String, String> labels) {
        this.eventLabels.clear();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (Event.isValidExtensionName((String)entry.getKey())) {
                this.eventLabels.put(entry.getKey(), entry.getValue());
                continue;
            }
            log.trace("Invalid event extension, {}:{}", (Object)entry.getKey(), (Object)entry.getValue());
            if (entry.getKey().length() > 20) {
                log.trace("Cannot convert event extension that is longer than 20 -> dropping label ({}:{}) because cloudevent spec disallows extensions with key longer than 20 chars", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            this.eventLabels.put(this.convertExtension(entry.getKey()), entry.getValue());
        }
    }

    private String convertExtension(String ext) {
        char[] arr = ext.toCharArray();
        StringBuilder strb = new StringBuilder();
        for (char c : arr) {
            if (Character.isAlphabetic(c)) {
                strb.append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isDigit(c)) continue;
            strb.append(c);
        }
        return strb.toString();
    }

    public void configure(Map<String, ?> configs) {
        this.eventEmitterConfig = new EventEmitterConfig(configs);
        Map<String, Map<String, Object>> eventExporterConfigs = this.eventEmitterConfig.getNonInternalExporterConfigs(EventEmitterConfig.EventType.events);
        if (eventExporterConfigs == null || eventExporterConfigs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : eventExporterConfigs.entrySet()) {
            if (!this.eventEmitterConfig.isKafkaExporter(entry.getValue())) continue;
            EventAsyncKafkaExporter ke = EventAsyncKafkaExporter.newBuilder(entry.getValue()).build();
            this.exportersMap.put(entry.getKey(), ke);
        }
    }

    public void close() {
        this.exportersMap.entrySet().forEach(entry -> {
            try {
                log.info("Closing exporter {}", entry.getKey());
                ((Exporter)entry.getValue()).close();
            }
            catch (Exception e) {
                log.error("Error when closing exporter {}", entry.getKey(), (Object)e);
            }
        });
    }

    @VisibleForTesting
    Map<String, Exporter<Event>> getExporters() {
        return this.exportersMap;
    }
}

