/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public final class NamedURI {
    private final URI uri;
    @Nullable
    private final String name;

    public NamedURI(URI uri, @Nullable String name) {
        this.uri = uri;
        this.name = name != null ? name.toLowerCase(Locale.ENGLISH) : null;
    }

    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedURI namedURI = (NamedURI)o;
        return this.uri.equals(namedURI.uri) && Objects.equals(this.name, namedURI.name);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.name);
    }

    public String toString() {
        return "NamedURI{uri=" + this.uri + ", name='" + this.name + "'}";
    }
}

