/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.ServerClusterId;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ServerMetadata {
    private final String version;
    private final ServerClusterId clusterId;

    @JsonCreator
    public ServerMetadata(@JsonProperty(value="version") String version, @JsonProperty(value="clusterId") ServerClusterId clusterId) {
        this.version = Objects.requireNonNull(version, "version");
        this.clusterId = Objects.requireNonNull(clusterId, "clusterId");
    }

    public String getVersion() {
        return this.version;
    }

    public ServerClusterId getClusterId() {
        return this.clusterId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerMetadata that = (ServerMetadata)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.clusterId, that.clusterId);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.clusterId);
    }
}

