/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.rest.entity.ConnectorType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorInfo {
    private final String name;
    private final ImmutableMap<String, String> config;
    private final ImmutableList<ConnectorTaskId> tasks;
    private final ConnectorType type;

    @JsonCreator
    public ConnectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="tasks") List<ConnectorTaskId> tasks, @JsonProperty(value="type") ConnectorType type) {
        this.name = name;
        this.config = ImmutableMap.copyOf(config);
        this.tasks = ImmutableList.copyOf(tasks);
        this.type = type;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public ConnectorType type() {
        return this.type;
    }

    @JsonProperty
    public Map<String, String> config() {
        return this.config;
    }

    @JsonProperty
    public List<ConnectorTaskId> tasks() {
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectorInfo that = (ConnectorInfo)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.config, that.config) && Objects.equals(this.tasks, that.tasks) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.config, this.type});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConnectorTaskId
    implements Serializable,
    Comparable<ConnectorTaskId> {
        private final String connector;
        private final int task;

        @JsonCreator
        public ConnectorTaskId(@JsonProperty(value="connector") String connector, @JsonProperty(value="task") int task) {
            this.connector = connector;
            this.task = task;
        }

        @JsonProperty
        public String connector() {
            return this.connector;
        }

        @JsonProperty
        public int task() {
            return this.task;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                ConnectorTaskId that = (ConnectorTaskId)o;
                return this.task != that.task ? false : Objects.equals(this.connector, that.connector);
            }
            return false;
        }

        public int hashCode() {
            int result = this.connector != null ? this.connector.hashCode() : 0;
            result = 31 * result + this.task;
            return result;
        }

        public String toString() {
            return this.connector + '-' + this.task;
        }

        @Override
        public int compareTo(ConnectorTaskId o) {
            int connectorCmp = this.connector.compareTo(o.connector);
            return connectorCmp != 0 ? connectorCmp : Integer.compare(this.task, o.task);
        }
    }
}

