/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigInfos {
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="error_count")
    private final int errorCount;
    @JsonProperty(value="groups")
    private final ImmutableList<String> groups;
    @JsonProperty(value="configs")
    private final ImmutableList<ConfigInfo> configs;

    @JsonCreator
    public ConfigInfos(@JsonProperty(value="name") String name, @JsonProperty(value="error_count") int errorCount, @JsonProperty(value="groups") List<String> groups, @JsonProperty(value="configs") List<ConfigInfo> configs) {
        this.name = name;
        this.errorCount = errorCount;
        this.groups = ImmutableList.copyOf(groups);
        this.configs = ImmutableList.copyOf(configs);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public int errorCount() {
        return this.errorCount;
    }

    @JsonProperty
    public List<String> groups() {
        return this.groups;
    }

    @JsonProperty(value="configs")
    public List<ConfigInfo> values() {
        return this.configs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConfigInfos that = (ConfigInfos)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.errorCount, that.errorCount) && Objects.equals(this.groups, that.groups) && Objects.equals(this.configs, that.configs);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.errorCount, this.groups, this.configs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.name).append(",").append(this.errorCount).append(",").append(this.groups).append(",").append(this.configs).append("]");
        return sb.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConfigValueInfo {
        private final String name;
        private final ImmutableList<String> errors;

        @JsonCreator
        public ConfigValueInfo(@JsonProperty(value="name") String name, @JsonProperty(value="errors") List<String> errors) {
            this.name = name;
            this.errors = ImmutableList.copyOf(errors);
        }

        @JsonProperty
        public String name() {
            return this.name;
        }

        @JsonProperty
        public List<String> errors() {
            return this.errors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                ConfigValueInfo that = (ConfigValueInfo)o;
                return Objects.equals(this.name, that.name) && Objects.equals(this.errors, that.errors);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.errors);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.name).append(",").append(this.errors).append("]");
            return sb.toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConfigInfo {
        private final ConfigValueInfo configValue;

        @JsonCreator
        public ConfigInfo(@JsonProperty(value="value") ConfigValueInfo configValue) {
            this.configValue = configValue;
        }

        @JsonProperty(value="value")
        public ConfigValueInfo configValue() {
            return this.configValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                ConfigInfo that = (ConfigInfo)o;
                return Objects.equals(this.configValue, that.configValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.configValue);
        }

        public String toString() {
            return "[" + this.configValue + "]";
        }
    }
}

