/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.Map;

public final class EndpointResponse {
    private final Map<String, String> headers;
    private final int status;
    private final Object entity;

    private EndpointResponse(Map<String, String> headers, int status, Object entity) {
        this.headers = headers;
        this.status = status;
        this.entity = entity;
    }

    public int getStatus() {
        return this.status;
    }

    public Object getEntity() {
        return this.entity;
    }

    public static Builder create() {
        return new Builder();
    }

    public static EndpointResponse ok(Object entity) {
        return new EndpointResponse(null, HttpResponseStatus.OK.code(), entity);
    }

    public static EndpointResponse failed(int status) {
        return new EndpointResponse(null, status, null);
    }

    public static final class Builder {
        private int status;
        private Map<String, String> headers;
        private Object entity;

        private Builder() {
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder header(String key, Object value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value.toString());
            return this;
        }

        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Builder type(String contentType) {
            return this.header("content-type", contentType);
        }

        public EndpointResponse build() {
            return new EndpointResponse(this.headers, this.status, this.entity);
        }
    }
}

