/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;

public final class ErrorMessageUtil {
    private static final String PREFIX = "Caused by: ";

    private ErrorMessageUtil() {
    }

    public static String buildErrorMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        List<String> messages = ErrorMessageUtil.dedup(ErrorMessageUtil.getErrorMessages(throwable));
        String msg = messages.remove(0);
        String causeMsg = messages.stream().filter(s -> !s.isEmpty()).map(cause -> WordUtils.wrap((String)(PREFIX + cause), (int)80, (String)"\n\t", (boolean)true)).collect(Collectors.joining(System.lineSeparator()));
        return causeMsg.isEmpty() ? msg : msg + System.lineSeparator() + causeMsg;
    }

    public static List<String> getErrorMessages(Throwable e) {
        return ErrorMessageUtil.getThrowables(e).stream().map(ErrorMessageUtil::getErrorMessage).collect(Collectors.toList());
    }

    private static String getErrorMessage(Throwable e) {
        if (e instanceof ConnectException) {
            return "Could not connect to the server. Please check the server details are correct and that the server is running.";
        }
        return e.getMessage() == null ? e.toString() : e.getMessage();
    }

    private static List<Throwable> getThrowables(Throwable e) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (Throwable cause = e; cause != null && !list.contains(cause); cause = cause.getCause()) {
            list.add(cause);
        }
        return list;
    }

    private static List<String> dedup(List<String> messages) {
        return new ArrayList<String>(new LinkedHashSet<String>(messages));
    }
}

