/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.util.KsqlException;

public class DuplicateColumnException
extends KsqlException {
    private final Column.Namespace namespace;
    private final Column column;

    public DuplicateColumnException(Column.Namespace namespace, Column column) {
        super(DuplicateColumnException.buildMessage(namespace, column));
        this.namespace = namespace;
        this.column = column;
    }

    public Column.Namespace getNamespace() {
        return this.namespace;
    }

    public Column getColumn() {
        return this.column;
    }

    private static String buildMessage(Column.Namespace namespace, Column column) {
        return String.format("Duplicate %s columns found in schema: %s", namespace == Column.Namespace.KEY ? "key" : "value", column);
    }
}

