/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.util.GrammaticalJoiner;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public final class SerdeFeatures {
    public static final ImmutableSet<SerdeFeature> WRAPPING_FEATURES = ImmutableSet.of((Object)((Object)SerdeFeature.WRAP_SINGLES), (Object)((Object)SerdeFeature.UNWRAP_SINGLES));
    private final ImmutableSet<SerdeFeature> features;

    @JsonCreator
    public static SerdeFeatures from(Set<SerdeFeature> features) {
        return new SerdeFeatures(features);
    }

    public static SerdeFeatures of(SerdeFeature ... features) {
        return new SerdeFeatures((Set<SerdeFeature>)ImmutableSet.copyOf((Object[])features));
    }

    private SerdeFeatures(Set<SerdeFeature> features) {
        SerdeFeatures.validate(features);
        this.features = ImmutableSet.copyOf(features);
    }

    public boolean enabled(SerdeFeature feature) {
        return this.features.contains((Object)feature);
    }

    @JsonValue
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="incompatibleWith is ImmutableSet")
    public Set<SerdeFeature> all() {
        return this.features;
    }

    public Optional<SerdeFeature> findAny(Set<SerdeFeature> anyOf) {
        return anyOf.stream().filter(arg_0 -> this.features.contains(arg_0)).findAny();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerdeFeatures that = (SerdeFeatures)o;
        return Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.features);
    }

    public String toString() {
        return this.features.toString();
    }

    private static void validate(Set<SerdeFeature> features) {
        features.forEach(f -> {
            Sets.SetView incompatible = Sets.intersection(f.getIncompatibleWith(), (Set)features);
            if (!incompatible.isEmpty()) {
                throw new IllegalArgumentException("Can't set " + (Object)f + " with " + GrammaticalJoiner.or().join((Iterable<?>)incompatible));
            }
        });
    }

    public static final class NOT_EMPTY {
        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS", "EQ_UNUSUAL"})
        public boolean equals(Object obj) {
            if (!(obj instanceof SerdeFeatures)) {
                return false;
            }
            return ((SerdeFeatures)obj).features.isEmpty();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

