/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class FormatInfo {
    private final String format;
    private final ImmutableMap<String, String> properties;

    public static FormatInfo of(String format) {
        return FormatInfo.of(format, (Map<String, String>)ImmutableMap.of());
    }

    @JsonCreator
    public static FormatInfo of(@JsonProperty(value="format", required=true) String format, @JsonProperty(value="properties") Optional<Map<String, String>> properties) {
        return new FormatInfo(format, properties.orElse((Map<String, String>)ImmutableMap.of()));
    }

    public static FormatInfo of(String format, Map<String, String> properties) {
        return new FormatInfo(format, properties);
    }

    private FormatInfo(String format, Map<String, String> properties) {
        this.format = Objects.requireNonNull(format, "format").toUpperCase();
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties"));
    }

    public String getFormat() {
        return this.format;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableMap")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormatInfo that = (FormatInfo)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.properties);
    }

    public String toString() {
        return "FormatInfo{format=" + this.format + ", properties=" + this.properties + '}';
    }
}

