/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.Set;

public final class SystemColumns {
    public static final ColumnName ROWKEY_NAME = ColumnName.of("ROWKEY");
    public static final ColumnName ROWTIME_NAME = ColumnName.of("ROWTIME");
    public static final SqlType ROWTIME_TYPE = SqlTypes.BIGINT;
    public static final ColumnName WINDOWSTART_NAME = ColumnName.of("WINDOWSTART");
    public static final ColumnName WINDOWEND_NAME = ColumnName.of("WINDOWEND");
    public static final SqlType WINDOWBOUND_TYPE = SqlTypes.BIGINT;
    public static final int LEGACY_PSEUDOCOLUMN_VERSION_NUMBER = 0;
    public static final int CURRENT_PSEUDOCOLUMN_VERSION_NUMBER = 5;
    private static final Set<ColumnName> PSEUDO_COLUMN_NAMES = ImmutableSet.of((Object)ROWTIME_NAME);
    private static final Set<ColumnName> WINDOW_BOUNDS_COLUMN_NAMES = ImmutableSet.of((Object)WINDOWSTART_NAME, (Object)WINDOWEND_NAME);
    private static final Set<ColumnName> SYSTEM_COLUMN_NAMES = ImmutableSet.builder().addAll(PSEUDO_COLUMN_NAMES).addAll(WINDOW_BOUNDS_COLUMN_NAMES).build();

    private SystemColumns() {
    }

    public static boolean isWindowBound(ColumnName columnName) {
        return SystemColumns.windowBoundsColumnNames().contains(columnName);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="WINDOW_BOUNDS_COLUMN_NAMES is ImmutableSet")
    public static Set<ColumnName> windowBoundsColumnNames() {
        return WINDOW_BOUNDS_COLUMN_NAMES;
    }

    public static boolean isPseudoColumn(ColumnName columnName) {
        return SystemColumns.pseudoColumnNames().contains(columnName);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="PSEUDO_COLUMN_NAMES is ImmutableSet")
    public static Set<ColumnName> pseudoColumnNames() {
        return PSEUDO_COLUMN_NAMES;
    }

    public static boolean isSystemColumn(ColumnName columnName) {
        return SystemColumns.systemColumnNames().contains(columnName);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="SYSTEM_COLUMN_NAMES is ImmutableSet")
    public static Set<ColumnName> systemColumnNames() {
        return SYSTEM_COLUMN_NAMES;
    }
}

