/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfIndex<T extends FunctionSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(UdfIndex.class);
    private final String udfName;
    private final Node root = new Node();
    private final Map<List<ParamType>, T> allFunctions;
    private final boolean supportsImplicitCasts;

    UdfIndex(String udfName, boolean supportsImplicitCasts) {
        this.udfName = Objects.requireNonNull(udfName, "udfName");
        this.allFunctions = new HashMap<List<ParamType>, T>();
        this.supportsImplicitCasts = supportsImplicitCasts;
    }

    void addFunction(T function) {
        Node curr;
        List<ParamType> parameters = function.parameters();
        if (this.allFunctions.put(parameters, function) != null) {
            throw new KsqlFunctionException("Can't add function " + function.name() + " with parameters " + function.parameters() + " as a function with the same name and parameter types already exists " + this.allFunctions.get(parameters));
        }
        Node parent = curr = this.root;
        for (ParamType parameter : parameters) {
            Parameter param = new Parameter(parameter, false);
            parent = curr;
            curr = curr.children.computeIfAbsent(param, ignored -> new Node());
        }
        if (function.isVariadic()) {
            parent.update(function);
            ParamType varargSchema = (ParamType)Iterables.getLast(parameters);
            Parameter vararg = new Parameter(varargSchema, true);
            Node leaf = parent.children.computeIfAbsent(vararg, ignored -> new Node());
            leaf.update(function);
            leaf.children.putIfAbsent(vararg, leaf);
        }
        curr.update(function);
    }

    T getFunction(List<SqlArgument> arguments) {
        Optional<T> candidate = this.findMatchingCandidate(arguments, false);
        if (candidate.isPresent()) {
            return (T)((FunctionSignature)candidate.get());
        }
        if (!this.supportsImplicitCasts) {
            throw this.createNoMatchingFunctionException(arguments);
        }
        candidate = this.findMatchingCandidate(arguments, true);
        if (candidate.isPresent()) {
            return (T)((FunctionSignature)candidate.get());
        }
        throw this.createNoMatchingFunctionException(arguments);
    }

    private Optional<T> findMatchingCandidate(List<SqlArgument> arguments, boolean allowCasts) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        this.getCandidates(arguments, 0, this.root, candidates, new HashMap<GenericType, SqlType>(), allowCasts);
        candidates.sort(Node::compare);
        int len = candidates.size();
        if (len == 1) {
            return Optional.of(((Node)candidates.get(0)).value);
        }
        if (len > 1) {
            if (((Node)candidates.get(len - 1)).compare((Node)candidates.get(len - 2)) > 0) {
                return Optional.of(((Node)candidates.get(len - 1)).value);
            }
            throw this.createVagueImplicitCastException(arguments);
        }
        return Optional.empty();
    }

    private void getCandidates(List<SqlArgument> arguments, int argIndex, Node current, List<Node> candidates, Map<GenericType, SqlType> reservedGenerics, boolean allowCasts) {
        if (argIndex == arguments.size()) {
            if (current.value != null) {
                candidates.add(current);
            }
            return;
        }
        SqlArgument arg = arguments.get(argIndex);
        for (Map.Entry candidate : current.children.entrySet()) {
            HashMap<GenericType, SqlType> reservedCopy = new HashMap<GenericType, SqlType>(reservedGenerics);
            if (!((Parameter)candidate.getKey()).accepts(arg, reservedCopy, allowCasts)) continue;
            Node node = (Node)candidate.getValue();
            this.getCandidates(arguments, argIndex + 1, node, candidates, reservedCopy, allowCasts);
        }
    }

    private String getParamsAsString(List<SqlArgument> paramTypes) {
        return paramTypes.stream().map(argument -> {
            if (argument == null) {
                return "null";
            }
            return argument.toString(FormatOptions.noEscape());
        }).collect(Collectors.joining(", ", "(", ")"));
    }

    private String getAcceptedTypesAsString() {
        return this.allFunctions.values().stream().map(UdfIndex::formatAvailableSignatures).collect(Collectors.joining(System.lineSeparator()));
    }

    private KsqlException createVagueImplicitCastException(List<SqlArgument> paramTypes) {
        LOG.debug("Current UdfIndex:\n{}", (Object)this.describe());
        throw new KsqlException("Function '" + this.udfName + "' cannot be resolved due to ambiguous method parameters " + this.getParamsAsString(paramTypes) + "." + System.lineSeparator() + "Use CAST() to explicitly cast your parameters to one of the supported function calls." + System.lineSeparator() + "Valid function calls are:" + System.lineSeparator() + this.getAcceptedTypesAsString() + System.lineSeparator() + "For detailed information on a function run: DESCRIBE FUNCTION <Function-Name>;");
    }

    private KsqlException createNoMatchingFunctionException(List<SqlArgument> paramTypes) {
        LOG.debug("Current UdfIndex:\n{}", (Object)this.describe());
        String requiredTypes = this.getParamsAsString(paramTypes);
        String acceptedTypes = this.getAcceptedTypesAsString();
        return new KsqlException("Function '" + this.udfName + "' does not accept parameters " + requiredTypes + "." + System.lineSeparator() + "Valid alternatives are:" + System.lineSeparator() + acceptedTypes + System.lineSeparator() + "For detailed information on a function run: DESCRIBE FUNCTION <Function-Name>;");
    }

    public Collection<T> values() {
        return this.allFunctions.values();
    }

    private String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("-ROOT\n");
        this.root.describe(sb, 1);
        return sb.toString();
    }

    private static <T extends FunctionSignature> String formatAvailableSignatures(T function) {
        boolean variadicFunction = function.isVariadic();
        List<ParameterInfo> parameters = function.parameterInfo();
        StringBuilder result = new StringBuilder();
        result.append(function.name().toString(FormatOptions.noEscape())).append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            String type;
            ParameterInfo param = parameters.get(i);
            boolean variadicParam = variadicFunction && i == parameters.size() - 1;
            String string = type = variadicParam ? ((ArrayType)param.type()).element().toString() + "..." : param.type().toString();
            if (i != 0) {
                result.append(", ");
            }
            result.append(type);
            if (param.name().isEmpty()) continue;
            result.append(" ").append(param.name());
        }
        return result.append(")").toString();
    }

    private static final class Parameter {
        private final ParamType type;
        private final boolean isVararg;

        private Parameter(ParamType type, boolean isVararg) {
            this.isVararg = isVararg;
            this.type = isVararg ? ((ArrayType)type).element() : type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.isVararg == parameter.isVararg && Objects.equals(this.type, parameter.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.isVararg);
        }

        boolean accepts(SqlArgument argument, Map<GenericType, SqlType> reservedGenerics, boolean allowCasts) {
            if (argument == null || !argument.getSqlLambda().isPresent() && !argument.getSqlType().isPresent()) {
                return true;
            }
            if (GenericsUtil.hasGenerics(this.type)) {
                return GenericsUtil.reserveGenerics(this.type, argument, reservedGenerics).getLeft();
            }
            return ParamTypes.areCompatible(argument, this.type, allowCasts);
        }

        public String toString() {
            return this.type + (this.isVararg ? "(VARARG)" : "");
        }
    }

    private final class Node {
        @VisibleForTesting
        private final Comparator<T> compareFunctions = Comparator.nullsFirst(Comparator.comparing(fun -> fun.isVariadic() ? 0 : 1).thenComparing(fun -> fun.parameters().size()));
        private final Map<Parameter, Node> children = new HashMap<Parameter, Node>();
        private T value = null;

        private Node() {
        }

        private void update(T function) {
            if (this.compareFunctions.compare(function, this.value) > 0) {
                this.value = function;
            }
        }

        private void describe(StringBuilder builder, int indent) {
            for (Map.Entry<Parameter, Node> child : this.children.entrySet()) {
                if (child.getValue() == this) continue;
                builder.append(StringUtils.repeat((char)' ', (int)(indent * 2))).append('-').append(child.getKey()).append(": ").append(child.getValue()).append('\n');
                child.getValue().describe(builder, indent + 1);
            }
        }

        public String toString() {
            return this.value != null ? this.value.name().text() : "EMPTY";
        }

        int compare(Node other) {
            int compareVal = this.compareFunctions.compare(this.value, other.value);
            return compareVal == 0 ? this.countGenerics(other) - this.countGenerics(this) : compareVal;
        }

        private int countGenerics(Node node) {
            return node.value.parameters().stream().filter(GenericsUtil::hasGenerics).mapToInt(p -> 1).sum();
        }
    }
}

