/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class GenericKey {
    @EffectivelyImmutable
    private final List<Object> values;

    public static Builder builder(LogicalSchema schema) {
        return GenericKey.builder(schema.key().size());
    }

    public static Builder builder(int numKeyColumns) {
        return new Builder(numKeyColumns);
    }

    public static GenericKey genericKey(Object ... columns) {
        return GenericKey.fromList(Arrays.asList(columns));
    }

    public static GenericKey fromList(List<?> columns) {
        return GenericKey.builder(columns.size()).appendAll(columns).build();
    }

    private GenericKey(List<Object> values) {
        this.values = Collections.unmodifiableList(values);
    }

    public int size() {
        return this.values.size();
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="values is unmodifiableList()")
    public List<?> values() {
        return this.values;
    }

    public String toString() {
        return this.values.stream().map(GenericRow::formatValue).collect(Collectors.joining(", ", "[", "]"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericKey that = (GenericKey)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public static final class Builder {
        private final int numColumns;
        private final List<Object> values;

        private Builder(int numColumns) {
            this.numColumns = numColumns;
            this.values = new ArrayList<Object>(numColumns);
        }

        public Builder append(Object value) {
            this.values.add(value);
            return this;
        }

        public Builder appendAll(List<?> values) {
            this.values.addAll(values);
            return this;
        }

        public Builder appendNulls() {
            while (this.values.size() < this.numColumns) {
                this.values.add(null);
            }
            return this;
        }

        public GenericKey build() {
            if (this.values.size() != this.numColumns) {
                throw new IllegalStateException("Expected " + this.numColumns + " values, only got " + this.values.size());
            }
            return new GenericKey(this.values);
        }
    }
}

