/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.StreamedQueryResult;
import io.confluent.ksql.api.client.exception.KsqlException;
import io.confluent.ksql.api.client.impl.QueryResponseHandler;
import io.confluent.ksql.api.client.impl.RowImpl;
import io.confluent.ksql.api.client.impl.StreamedQueryResultImpl;
import io.confluent.ksql.api.client.util.RowUtil;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.parsetools.RecordParser;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class StreamQueryResponseHandler
extends QueryResponseHandler<CompletableFuture<StreamedQueryResult>> {
    private StreamedQueryResultImpl queryResult;
    private Map<String, Integer> columnNameToIndex;
    private boolean paused;

    StreamQueryResponseHandler(Context context, RecordParser recordParser, CompletableFuture<StreamedQueryResult> cf) {
        super(context, recordParser, cf);
    }

    @Override
    protected void handleMetadata(QueryResponseMetadata queryResponseMetadata) {
        this.queryResult = new StreamedQueryResultImpl(this.context, queryResponseMetadata.queryId, queryResponseMetadata.columnNames, RowUtil.columnTypesFromStrings(queryResponseMetadata.columnTypes));
        this.columnNameToIndex = RowUtil.valueToIndexMap(queryResponseMetadata.columnNames);
        this.cf.complete(this.queryResult);
    }

    @Override
    protected void handleRow(Buffer buff) {
        if (this.queryResult == null) {
            throw new IllegalStateException("handleRow called before metadata processed");
        }
        Object json = buff.toJson();
        if (json instanceof JsonArray) {
            RowImpl row = new RowImpl(this.queryResult.columnNames(), this.queryResult.columnTypes(), (JsonArray)json, this.columnNameToIndex);
            boolean full = this.queryResult.accept(row);
            if (full && !this.paused) {
                this.recordParser.pause();
                this.queryResult.drainHandler(this::publisherReceptive);
                this.paused = true;
            }
        } else if (json instanceof JsonObject) {
            JsonObject error = (JsonObject)json;
            this.queryResult.handleError(new KsqlException(error.getString("message")));
        } else {
            throw new RuntimeException("Could not decode JSON: " + json);
        }
    }

    @Override
    protected void doHandleBodyEnd() {
        this.queryResult.complete();
    }

    @Override
    public void handleExceptionAfterFutureCompleted(Throwable t) {
        this.queryResult.handleError(new Exception(t));
    }

    private void publisherReceptive() {
        this.checkContext();
        this.paused = false;
        this.recordParser.resume();
    }
}

