/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class ResponseHandler<T extends CompletableFuture<?>> {
    protected final Context context;
    protected final RecordParser recordParser;
    protected final T cf;

    ResponseHandler(Context context, RecordParser recordParser, T cf) {
        this.context = Objects.requireNonNull(context);
        this.recordParser = Objects.requireNonNull(recordParser);
        this.cf = (CompletableFuture)Objects.requireNonNull(cf);
    }

    public void handleBodyBuffer(Buffer buff) {
        this.checkContext();
        this.doHandleBodyBuffer(buff);
    }

    public void handleException(Throwable t) {
        this.checkContext();
        this.doHandleException(t);
    }

    public void handleBodyEnd(Void v) {
        this.checkContext();
        this.doHandleBodyEnd();
    }

    protected abstract void doHandleBodyBuffer(Buffer var1);

    protected abstract void doHandleException(Throwable var1);

    protected abstract void doHandleBodyEnd();

    protected void checkContext() {
        VertxUtils.checkContext((Context)this.context);
    }
}

