/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonPropertyOrder;

@JsonPropertyOrder(value={"keytype", "subject", "magic"})
public class ModeKey
extends SchemaRegistryKey {
    private static final int MAGIC_BYTE = 0;
    private String subject;

    public ModeKey(@JsonProperty(value="subject") String subject) {
        super(SchemaRegistryKeyType.MODE);
        this.subject = subject;
        this.magicByte = 0;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModeKey modeKey = (ModeKey)o;
        return Objects.equals(this.subject, modeKey.subject);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("keytype=" + this.keyType.keyType + ",");
        sb.append("subject=" + this.subject + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            ModeKey otherKey = (ModeKey)o;
            if (this.subject == null && otherKey.subject == null) {
                return 0;
            }
            if (this.subject == null) {
                return -1;
            }
            if (otherKey.subject == null) {
                return 1;
            }
            return this.subject.compareTo(otherKey.subject);
        }
        return compare;
    }
}

