/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.id;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;

public class IncrementalIdGenerator
implements IdGenerator {
    private volatile int maxIdInKafkaStore = -1;

    @Override
    public int id(Schema schema) throws IdGenerationException {
        int nextId = Math.max(1, this.maxIdInKafkaStore + 1);
        return nextId;
    }

    @Override
    public void configure(SchemaRegistryConfig config) {
    }

    @Override
    public void init() throws IdGenerationException {
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue) {
        if (this.maxIdInKafkaStore < schemaValue.getId()) {
            this.maxIdInKafkaStore = schemaValue.getId();
        }
    }
}

