/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.UploadSchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="register", configurator="custom-basic")
public class RegisterSchemaRegistryMojo
extends UploadSchemaRegistryMojo {
    @Parameter(required=false)
    boolean normalizeSchemas = false;

    @Override
    protected boolean processSchema(String subject, File schemaPath, ParsedSchema schema, Map<String, Integer> schemaVersions) throws IOException, RestClientException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Calling register('%s', '%s')", subject, schema));
        }
        Integer id = this.client().register(subject, schema, this.normalizeSchemas);
        Integer version = this.client().getVersion(subject, schema, this.normalizeSchemas);
        this.getLog().info((CharSequence)String.format("Registered subject(%s) with id %s version %s", subject, id, version));
        schemaVersions.put(subject, version);
        return true;
    }
}

