/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    public static final String TYPE = "AVRO";
    private final Schema schemaObj;
    private String canonicalString;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private final boolean isNew;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;

    public AvroSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this(schemaString, references, resolvedReferences, version, false);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, boolean isNew) {
        this.isNew = isNew;
        Schema.Parser parser = this.getParser();
        for (String schema : resolvedReferences.values()) {
            parser.parse(schema);
        }
        this.schemaObj = parser.parse(schemaString);
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.version = version;
    }

    public AvroSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public AvroSchema(Schema schemaObj, Integer version) {
        this.isNew = false;
        this.schemaObj = schemaObj;
        this.references = Collections.emptyList();
        this.resolvedReferences = Collections.emptyMap();
        this.version = version;
    }

    private AvroSchema(Schema schemaObj, String canonicalString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, boolean isNew) {
        this.isNew = isNew;
        this.schemaObj = schemaObj;
        this.canonicalString = canonicalString;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.version = version;
    }

    public AvroSchema copy() {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, this.version, this.isNew);
    }

    protected Schema.Parser getParser() {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(this.isNew());
        return parser;
    }

    public Schema rawSchema() {
        return this.schemaObj;
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        if (this.schemaObj != null && this.schemaObj.getType() == Schema.Type.RECORD) {
            return this.schemaObj.getFullName();
        }
        return null;
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            Schema.Parser parser = this.getParser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (String schema : this.resolvedReferences.values()) {
                Schema schemaRef = parser.parse(schema);
                schemaRefs.add(schemaRef);
            }
            this.canonicalString = this.schemaObj.toString(schemaRefs, false);
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public AvroSchema normalize() {
        String normalized = AvroSchemaUtils.toNormalizedString(this);
        return new AvroSchema(normalized, this.references.stream().sorted().distinct().collect(Collectors.toList()), this.resolvedReferences, this.version, this.isNew);
    }

    @Override
    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Collections.singletonList("Incompatible because of different schema type");
        }
        try {
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)this.schemaObj, (Schema)((AvroSchema)previousSchema).schemaObj);
            return result.getResult().getIncompatibilities().stream().map(SchemaCompatibility.Incompatibility::toString).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Unexpected exception during compatibility check", (Throwable)e);
            return Collections.singletonList("Unexpected exception during compatibility check: " + e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroSchema that = (AvroSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.schemaObj, that.schemaObj) && this.metaEqual(this.schemaObj, that.schemaObj, new HashMap<IdentityPair<Schema, Schema>, Boolean>());
    }

    private boolean metaEqual(Schema schema1, Schema schema2, Map<IdentityPair<Schema, Schema>, Boolean> cache) {
        Schema.Type type2;
        if (schema1 == schema2) {
            return true;
        }
        if (schema1 == null || schema2 == null) {
            return false;
        }
        Schema.Type type1 = schema1.getType();
        if (type1 != (type2 = schema2.getType())) {
            return false;
        }
        switch (type1) {
            case RECORD: {
                IdentityPair<Schema, Schema> sp = new IdentityPair<Schema, Schema>(schema1, schema2);
                Boolean cacheHit = cache.putIfAbsent(sp, true);
                if (cacheHit != null) {
                    return cacheHit;
                }
                boolean equals = Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc()) && this.fieldMetaEqual(schema1.getFields(), schema2.getFields(), cache);
                cache.put(sp, equals);
                return equals;
            }
            case ENUM: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc()) && Objects.equals(schema1.getEnumDefault(), schema2.getEnumDefault());
            }
            case FIXED: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc());
            }
            case UNION: {
                List types1 = schema1.getTypes();
                List types2 = schema2.getTypes();
                if (types1.size() != types2.size()) {
                    return false;
                }
                for (int i = 0; i < types1.size(); ++i) {
                    if (this.metaEqual((Schema)types1.get(i), (Schema)types2.get(i), cache)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean fieldMetaEqual(List<Schema.Field> fields1, List<Schema.Field> fields2, Map<IdentityPair<Schema, Schema>, Boolean> cache) {
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            Schema.Field field2;
            Schema.Field field1 = fields1.get(i);
            if (field1 == (field2 = fields2.get(i))) continue;
            if (!Objects.equals(field1.aliases(), field2.aliases()) || !Objects.equals(field1.doc(), field2.doc())) {
                return false;
            }
            boolean fieldSchemaMetaEqual = this.metaEqual(field1.schema(), field2.schema(), cache);
            if (fieldSchemaMetaEqual) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.schemaObj, this.references, this.version) + this.metaHash(this.schemaObj, new IdentityHashMap<Schema, Integer>());
        }
        return this.hashCode;
    }

    private int metaHash(Schema schema, Map<Schema, Integer> cache) {
        if (schema == null) {
            return 0;
        }
        switch (schema.getType()) {
            case RECORD: {
                Integer cacheHit = cache.putIfAbsent(schema, 0);
                if (cacheHit != null) {
                    return cacheHit;
                }
                int result = Objects.hash(schema.getAliases(), schema.getDoc()) + this.fieldMetaHash(schema.getFields(), cache);
                cache.put(schema, result);
                return result;
            }
            case ENUM: {
                return Objects.hash(schema.getAliases(), schema.getDoc(), schema.getEnumDefault());
            }
            case FIXED: {
                return Objects.hash(schema.getAliases(), schema.getDoc());
            }
            case UNION: {
                int hash = 0;
                List types = schema.getTypes();
                for (Schema type : types) {
                    hash += this.metaHash(type, cache);
                }
                return hash;
            }
        }
        return 0;
    }

    private int fieldMetaHash(List<Schema.Field> fields, Map<Schema, Integer> cache) {
        int hash = 0;
        for (Schema.Field field : fields) {
            hash += Objects.hash(field.aliases(), field.doc()) + this.metaHash(field.schema(), cache);
        }
        return hash;
    }

    public String toString() {
        return this.canonicalString();
    }

    static class IdentityPair<K, V> {
        private final K key;
        private final V value;

        public IdentityPair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityPair pair = (IdentityPair)o;
            return this.key == pair.key && this.value == pair.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.key) + System.identityHashCode(this.value);
        }

        public String toString() {
            return "IdentityPair{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

