/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.TinkProtoParametersFormat;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.daead.DeterministicAeadConfig;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.nio.BufferUnderflowException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutionException;

public class Cryptor {
    private final DekFormat dekFormat;
    private final KeyTemplate dekTemplate;
    private final LoadingCache<ByteString, DeterministicAead> deterministicAeads;
    private final LoadingCache<ByteString, Aead> aeads;
    private static final int DEFAULT_CACHE_SIZE = 100;

    public Cryptor(DekFormat dekFormat) throws GeneralSecurityException {
        KeyTemplate keyTemplate;
        try {
            keyTemplate = KeyTemplate.parseFrom((byte[])TinkProtoParametersFormat.serialize((Parameters)dekFormat.getParameters()), (ExtensionRegistryLite)ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (GeneralSecurityException e) {
            com.google.crypto.tink.KeyTemplate template = KeyTemplates.get((String)dekFormat.name());
            keyTemplate = KeyTemplate.newBuilder().setTypeUrl(template.getTypeUrl()).setValue(ByteString.copyFrom((byte[])template.getValue())).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException(e);
        }
        this.dekFormat = dekFormat;
        this.dekTemplate = keyTemplate;
        this.deterministicAeads = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<ByteString, DeterministicAead>(){

            public DeterministicAead load(ByteString dek) throws GeneralSecurityException {
                return (DeterministicAead)Registry.getPrimitive((String)Cryptor.this.dekTemplate.getTypeUrl(), (ByteString)dek, DeterministicAead.class);
            }
        });
        this.aeads = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<ByteString, Aead>(){

            public Aead load(ByteString dek) throws GeneralSecurityException {
                return (Aead)Registry.getPrimitive((String)Cryptor.this.dekTemplate.getTypeUrl(), (ByteString)dek, Aead.class);
            }
        });
    }

    public DekFormat getDekFormat() {
        return this.dekFormat;
    }

    public byte[] generateKey() throws GeneralSecurityException {
        return Registry.newKeyData((KeyTemplate)this.dekTemplate).getValue().toByteArray();
    }

    public byte[] encrypt(byte[] dek, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        byte[] ciphertext;
        if (this.dekFormat.isDeterministic()) {
            DeterministicAead aead = this.getDeterministicAead(dek);
            ciphertext = aead.encryptDeterministically(plaintext, associatedData);
        } else {
            Aead aead = this.getAead(dek);
            ciphertext = aead.encrypt(plaintext, associatedData);
        }
        return ciphertext;
    }

    public byte[] decrypt(byte[] dek, byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            if (this.dekFormat.isDeterministic()) {
                DeterministicAead aead = this.getDeterministicAead(dek);
                return aead.decryptDeterministically(ciphertext, associatedData);
            }
            Aead aead = this.getAead(dek);
            return aead.decrypt(ciphertext, associatedData);
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | BufferUnderflowException e) {
            throw new GeneralSecurityException("invalid ciphertext", e);
        }
    }

    private DeterministicAead getDeterministicAead(byte[] dek) throws GeneralSecurityException {
        try {
            return (DeterministicAead)this.deterministicAeads.get((Object)ByteString.copyFrom((byte[])dek));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Aead getAead(byte[] dek) throws GeneralSecurityException {
        try {
            return (Aead)this.aeads.get((Object)ByteString.copyFrom((byte[])dek));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    static {
        try {
            AeadConfig.register();
            DeterministicAeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

