/*
 * Copyright 2021 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.kafkarest.ratelimit;

import static java.util.Objects.requireNonNull;

/** A {@link FixedCostRateLimiter} implementation that delegates to {@link RequestRateLimiter}. */
final class FixedCostRateLimiterImpl implements FixedCostRateLimiter {
  private final RequestRateLimiter delegate;
  private final int cost;

  FixedCostRateLimiterImpl(RequestRateLimiter delegate, int cost) {
    this.delegate = requireNonNull(delegate);
    this.cost = cost;
  }

  @Override
  public void rateLimit() {
    delegate.rateLimit(cost);
  }
}
