package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TopicDataList extends TopicDataList {

  private final String kind;

  private final ResourceCollection.Metadata metadata;

  private final ImmutableList<TopicData> data;

  private AutoValue_TopicDataList(
      String kind,
      ResourceCollection.Metadata metadata,
      ImmutableList<TopicData> data) {
    this.kind = kind;
    this.metadata = metadata;
    this.data = data;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public ResourceCollection.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("data")
  @Override
  public ImmutableList<TopicData> getData() {
    return data;
  }

  @Override
  public String toString() {
    return "TopicDataList{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TopicDataList) {
      TopicDataList that = (TopicDataList) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.data.equals(that.getData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  static final class Builder extends TopicDataList.Builder {
    private String kind;
    private ResourceCollection.Metadata metadata;
    private ImmutableList<TopicData> data;
    Builder() {
    }
    @Override
    public TopicDataList.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public TopicDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public TopicDataList.Builder setData(List<TopicData> data) {
      this.data = ImmutableList.copyOf(data);
      return this;
    }
    @Override
    public TopicDataList build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.data == null) {
        missing += " data";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TopicDataList(
          this.kind,
          this.metadata,
          this.data);
    }
  }

}
