package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafkarest.entities.Acl;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TopicData extends TopicData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String topicName;

  private final boolean internal;

  private final int replicationFactor;

  private final int partitionsCount;

  private final Resource.Relationship partitions;

  private final Resource.Relationship configs;

  private final Resource.Relationship partitionReassignments;

  private final ImmutableSet<Acl.Operation> authorizedOperations;

  private AutoValue_TopicData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String topicName,
      boolean internal,
      int replicationFactor,
      int partitionsCount,
      Resource.Relationship partitions,
      Resource.Relationship configs,
      Resource.Relationship partitionReassignments,
      ImmutableSet<Acl.Operation> authorizedOperations) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.topicName = topicName;
    this.internal = internal;
    this.replicationFactor = replicationFactor;
    this.partitionsCount = partitionsCount;
    this.partitions = partitions;
    this.configs = configs;
    this.partitionReassignments = partitionReassignments;
    this.authorizedOperations = authorizedOperations;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("is_internal")
  @Override
  public boolean isInternal() {
    return internal;
  }

  @JsonProperty("replication_factor")
  @Override
  public int getReplicationFactor() {
    return replicationFactor;
  }

  @JsonProperty("partitions_count")
  @Override
  public int getPartitionsCount() {
    return partitionsCount;
  }

  @JsonProperty("partitions")
  @Override
  public Resource.Relationship getPartitions() {
    return partitions;
  }

  @JsonProperty("configs")
  @Override
  public Resource.Relationship getConfigs() {
    return configs;
  }

  @JsonProperty("partition_reassignments")
  @Override
  public Resource.Relationship getPartitionReassignments() {
    return partitionReassignments;
  }

  @JsonProperty("authorized_operations")
  @Override
  public ImmutableSet<Acl.Operation> getAuthorizedOperations() {
    return authorizedOperations;
  }

  @Override
  public String toString() {
    return "TopicData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "internal=" + internal + ", "
        + "replicationFactor=" + replicationFactor + ", "
        + "partitionsCount=" + partitionsCount + ", "
        + "partitions=" + partitions + ", "
        + "configs=" + configs + ", "
        + "partitionReassignments=" + partitionReassignments + ", "
        + "authorizedOperations=" + authorizedOperations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TopicData) {
      TopicData that = (TopicData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.internal == that.isInternal()
          && this.replicationFactor == that.getReplicationFactor()
          && this.partitionsCount == that.getPartitionsCount()
          && this.partitions.equals(that.getPartitions())
          && this.configs.equals(that.getConfigs())
          && this.partitionReassignments.equals(that.getPartitionReassignments())
          && this.authorizedOperations.equals(that.getAuthorizedOperations());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= internal ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= replicationFactor;
    h$ *= 1000003;
    h$ ^= partitionsCount;
    h$ *= 1000003;
    h$ ^= partitions.hashCode();
    h$ *= 1000003;
    h$ ^= configs.hashCode();
    h$ *= 1000003;
    h$ ^= partitionReassignments.hashCode();
    h$ *= 1000003;
    h$ ^= authorizedOperations.hashCode();
    return h$;
  }

  static final class Builder extends TopicData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String topicName;
    private Boolean internal;
    private Integer replicationFactor;
    private Integer partitionsCount;
    private Resource.Relationship partitions;
    private Resource.Relationship configs;
    private Resource.Relationship partitionReassignments;
    private ImmutableSet<Acl.Operation> authorizedOperations;
    Builder() {
    }
    @Override
    public TopicData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public TopicData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public TopicData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public TopicData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public TopicData.Builder setInternal(boolean internal) {
      this.internal = internal;
      return this;
    }
    @Override
    public TopicData.Builder setReplicationFactor(int replicationFactor) {
      this.replicationFactor = replicationFactor;
      return this;
    }
    @Override
    public TopicData.Builder setPartitionsCount(int partitionsCount) {
      this.partitionsCount = partitionsCount;
      return this;
    }
    @Override
    public TopicData.Builder setPartitions(Resource.Relationship partitions) {
      if (partitions == null) {
        throw new NullPointerException("Null partitions");
      }
      this.partitions = partitions;
      return this;
    }
    @Override
    public TopicData.Builder setConfigs(Resource.Relationship configs) {
      if (configs == null) {
        throw new NullPointerException("Null configs");
      }
      this.configs = configs;
      return this;
    }
    @Override
    public TopicData.Builder setPartitionReassignments(Resource.Relationship partitionReassignments) {
      if (partitionReassignments == null) {
        throw new NullPointerException("Null partitionReassignments");
      }
      this.partitionReassignments = partitionReassignments;
      return this;
    }
    @Override
    public TopicData.Builder setAuthorizedOperations(Set<Acl.Operation> authorizedOperations) {
      this.authorizedOperations = ImmutableSet.copyOf(authorizedOperations);
      return this;
    }
    @Override
    public TopicData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.internal == null) {
        missing += " internal";
      }
      if (this.replicationFactor == null) {
        missing += " replicationFactor";
      }
      if (this.partitionsCount == null) {
        missing += " partitionsCount";
      }
      if (this.partitions == null) {
        missing += " partitions";
      }
      if (this.configs == null) {
        missing += " configs";
      }
      if (this.partitionReassignments == null) {
        missing += " partitionReassignments";
      }
      if (this.authorizedOperations == null) {
        missing += " authorizedOperations";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TopicData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.topicName,
          this.internal,
          this.replicationFactor,
          this.partitionsCount,
          this.partitions,
          this.configs,
          this.partitionReassignments,
          this.authorizedOperations);
    }
  }

}
