package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Resource_Metadata extends Resource.Metadata {

  private final String self;

  private final Optional<String> resourceName;

  private AutoValue_Resource_Metadata(
      String self,
      Optional<String> resourceName) {
    this.self = self;
    this.resourceName = resourceName;
  }

  @JsonProperty("self")
  @Override
  public String getSelf() {
    return self;
  }

  @JsonProperty("resource_name")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<String> getResourceName() {
    return resourceName;
  }

  @Override
  public String toString() {
    return "Metadata{"
        + "self=" + self + ", "
        + "resourceName=" + resourceName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Resource.Metadata) {
      Resource.Metadata that = (Resource.Metadata) o;
      return this.self.equals(that.getSelf())
          && this.resourceName.equals(that.getResourceName());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= self.hashCode();
    h$ *= 1000003;
    h$ ^= resourceName.hashCode();
    return h$;
  }

  static final class Builder extends Resource.Metadata.Builder {
    private String self;
    private Optional<String> resourceName = Optional.empty();
    Builder() {
    }
    @Override
    public Resource.Metadata.Builder setSelf(String self) {
      if (self == null) {
        throw new NullPointerException("Null self");
      }
      this.self = self;
      return this;
    }
    @Override
    public Resource.Metadata.Builder setResourceName(@Nullable String resourceName) {
      this.resourceName = Optional.ofNullable(resourceName);
      return this;
    }
    @Override
    public Resource.Metadata build() {
      String missing = "";
      if (this.self == null) {
        missing += " self";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Resource_Metadata(
          this.self,
          this.resourceName);
    }
  }

}
