package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReplicaData extends ReplicaData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final int brokerId;

  private final boolean leader;

  private final boolean inSync;

  private final Resource.Relationship broker;

  private AutoValue_ReplicaData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String topicName,
      int partitionId,
      int brokerId,
      boolean leader,
      boolean inSync,
      Resource.Relationship broker) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.brokerId = brokerId;
    this.leader = leader;
    this.inSync = inSync;
    this.broker = broker;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("broker_id")
  @Override
  public int getBrokerId() {
    return brokerId;
  }

  @JsonProperty("is_leader")
  @Override
  public boolean isLeader() {
    return leader;
  }

  @JsonProperty("is_in_sync")
  @Override
  public boolean isInSync() {
    return inSync;
  }

  @JsonProperty("broker")
  @Override
  public Resource.Relationship getBroker() {
    return broker;
  }

  @Override
  public String toString() {
    return "ReplicaData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "brokerId=" + brokerId + ", "
        + "leader=" + leader + ", "
        + "inSync=" + inSync + ", "
        + "broker=" + broker
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReplicaData) {
      ReplicaData that = (ReplicaData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.brokerId == that.getBrokerId()
          && this.leader == that.isLeader()
          && this.inSync == that.isInSync()
          && this.broker.equals(that.getBroker());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= brokerId;
    h$ *= 1000003;
    h$ ^= leader ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= inSync ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= broker.hashCode();
    return h$;
  }

  static final class Builder extends ReplicaData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String topicName;
    private Integer partitionId;
    private Integer brokerId;
    private Boolean leader;
    private Boolean inSync;
    private Resource.Relationship broker;
    Builder() {
    }
    @Override
    public ReplicaData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ReplicaData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ReplicaData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ReplicaData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ReplicaData.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ReplicaData.Builder setBrokerId(int brokerId) {
      this.brokerId = brokerId;
      return this;
    }
    @Override
    public ReplicaData.Builder setLeader(boolean leader) {
      this.leader = leader;
      return this;
    }
    @Override
    public ReplicaData.Builder setInSync(boolean inSync) {
      this.inSync = inSync;
      return this;
    }
    @Override
    public ReplicaData.Builder setBroker(Resource.Relationship broker) {
      if (broker == null) {
        throw new NullPointerException("Null broker");
      }
      this.broker = broker;
      return this;
    }
    @Override
    public ReplicaData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.brokerId == null) {
        missing += " brokerId";
      }
      if (this.leader == null) {
        missing += " leader";
      }
      if (this.inSync == null) {
        missing += " inSync";
      }
      if (this.broker == null) {
        missing += " broker";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ReplicaData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.topicName,
          this.partitionId,
          this.brokerId,
          this.leader,
          this.inSync,
          this.broker);
    }
  }

}
