package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReassignmentData extends ReassignmentData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final ImmutableList<Integer> addingReplicas;

  private final ImmutableList<Integer> removingReplicas;

  private final Resource.Relationship replicas;

  private AutoValue_ReassignmentData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String topicName,
      int partitionId,
      ImmutableList<Integer> addingReplicas,
      ImmutableList<Integer> removingReplicas,
      Resource.Relationship replicas) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.addingReplicas = addingReplicas;
    this.removingReplicas = removingReplicas;
    this.replicas = replicas;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("adding_replicas")
  @Override
  public ImmutableList<Integer> getAddingReplicas() {
    return addingReplicas;
  }

  @JsonProperty("removing_replicas")
  @Override
  public ImmutableList<Integer> getRemovingReplicas() {
    return removingReplicas;
  }

  @JsonProperty("replicas")
  @Override
  public Resource.Relationship getReplicas() {
    return replicas;
  }

  @Override
  public String toString() {
    return "ReassignmentData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "addingReplicas=" + addingReplicas + ", "
        + "removingReplicas=" + removingReplicas + ", "
        + "replicas=" + replicas
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReassignmentData) {
      ReassignmentData that = (ReassignmentData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.addingReplicas.equals(that.getAddingReplicas())
          && this.removingReplicas.equals(that.getRemovingReplicas())
          && this.replicas.equals(that.getReplicas());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= addingReplicas.hashCode();
    h$ *= 1000003;
    h$ ^= removingReplicas.hashCode();
    h$ *= 1000003;
    h$ ^= replicas.hashCode();
    return h$;
  }

  static final class Builder extends ReassignmentData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String topicName;
    private Integer partitionId;
    private ImmutableList<Integer> addingReplicas;
    private ImmutableList<Integer> removingReplicas;
    private Resource.Relationship replicas;
    Builder() {
    }
    @Override
    public ReassignmentData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ReassignmentData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ReassignmentData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ReassignmentData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ReassignmentData.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ReassignmentData.Builder setAddingReplicas(List<Integer> addingReplicas) {
      this.addingReplicas = ImmutableList.copyOf(addingReplicas);
      return this;
    }
    @Override
    public ReassignmentData.Builder setRemovingReplicas(List<Integer> removingReplicas) {
      this.removingReplicas = ImmutableList.copyOf(removingReplicas);
      return this;
    }
    @Override
    public ReassignmentData.Builder setReplicas(Resource.Relationship replicas) {
      if (replicas == null) {
        throw new NullPointerException("Null replicas");
      }
      this.replicas = replicas;
      return this;
    }
    @Override
    public ReassignmentData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.addingReplicas == null) {
        missing += " addingReplicas";
      }
      if (this.removingReplicas == null) {
        missing += " removingReplicas";
      }
      if (this.replicas == null) {
        missing += " replicas";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ReassignmentData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.topicName,
          this.partitionId,
          this.addingReplicas,
          this.removingReplicas,
          this.replicas);
    }
  }

}
