package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceResponse_ProduceResponseData extends ProduceResponse.ProduceResponseData {

  private final Optional<EmbeddedFormat> type;

  private final Optional<String> subject;

  private final Optional<Integer> schemaId;

  private final Optional<Integer> schemaVersion;

  private final int size;

  private AutoValue_ProduceResponse_ProduceResponseData(
      Optional<EmbeddedFormat> type,
      Optional<String> subject,
      Optional<Integer> schemaId,
      Optional<Integer> schemaVersion,
      int size) {
    this.type = type;
    this.subject = subject;
    this.schemaId = schemaId;
    this.schemaVersion = schemaVersion;
    this.size = size;
  }

  @JsonProperty("type")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<EmbeddedFormat> getType() {
    return type;
  }

  @JsonProperty("subject")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<String> getSubject() {
    return subject;
  }

  @JsonProperty("schema_id")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Integer> getSchemaId() {
    return schemaId;
  }

  @JsonProperty("schema_version")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Integer> getSchemaVersion() {
    return schemaVersion;
  }

  @JsonProperty("size")
  @Override
  public int getSize() {
    return size;
  }

  @Override
  public String toString() {
    return "ProduceResponseData{"
        + "type=" + type + ", "
        + "subject=" + subject + ", "
        + "schemaId=" + schemaId + ", "
        + "schemaVersion=" + schemaVersion + ", "
        + "size=" + size
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceResponse.ProduceResponseData) {
      ProduceResponse.ProduceResponseData that = (ProduceResponse.ProduceResponseData) o;
      return this.type.equals(that.getType())
          && this.subject.equals(that.getSubject())
          && this.schemaId.equals(that.getSchemaId())
          && this.schemaVersion.equals(that.getSchemaVersion())
          && this.size == that.getSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= schemaId.hashCode();
    h$ *= 1000003;
    h$ ^= schemaVersion.hashCode();
    h$ *= 1000003;
    h$ ^= size;
    return h$;
  }

  static final class Builder extends ProduceResponse.ProduceResponseData.Builder {
    private Optional<EmbeddedFormat> type = Optional.empty();
    private Optional<String> subject = Optional.empty();
    private Optional<Integer> schemaId = Optional.empty();
    private Optional<Integer> schemaVersion = Optional.empty();
    private Integer size;
    Builder() {
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setType(Optional<EmbeddedFormat> type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setType(@Nullable EmbeddedFormat type) {
      this.type = Optional.ofNullable(type);
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSubject(Optional<String> subject) {
      if (subject == null) {
        throw new NullPointerException("Null subject");
      }
      this.subject = subject;
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSubject(@Nullable String subject) {
      this.subject = Optional.ofNullable(subject);
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSchemaId(Optional<Integer> schemaId) {
      if (schemaId == null) {
        throw new NullPointerException("Null schemaId");
      }
      this.schemaId = schemaId;
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSchemaId(@Nullable Integer schemaId) {
      this.schemaId = Optional.ofNullable(schemaId);
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSchemaVersion(Optional<Integer> schemaVersion) {
      if (schemaVersion == null) {
        throw new NullPointerException("Null schemaVersion");
      }
      this.schemaVersion = schemaVersion;
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSchemaVersion(@Nullable Integer schemaVersion) {
      this.schemaVersion = Optional.ofNullable(schemaVersion);
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData.Builder setSize(int size) {
      this.size = size;
      return this;
    }
    @Override
    public ProduceResponse.ProduceResponseData build() {
      String missing = "";
      if (this.size == null) {
        missing += " size";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProduceResponse_ProduceResponseData(
          this.type,
          this.subject,
          this.schemaId,
          this.schemaVersion,
          this.size);
    }
  }

}
