package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceResponse extends ProduceResponse {

  private final int errorCode;

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final long offset;

  private final Optional<Instant> timestamp;

  private final Optional<ProduceResponse.ProduceResponseData> key;

  private final Optional<ProduceResponse.ProduceResponseData> value;

  private AutoValue_ProduceResponse(
      int errorCode,
      String clusterId,
      String topicName,
      int partitionId,
      long offset,
      Optional<Instant> timestamp,
      Optional<ProduceResponse.ProduceResponseData> key,
      Optional<ProduceResponse.ProduceResponseData> value) {
    this.errorCode = errorCode;
    this.clusterId = clusterId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.offset = offset;
    this.timestamp = timestamp;
    this.key = key;
    this.value = value;
  }

  @JsonProperty("error_code")
  @Override
  public int getErrorCode() {
    return errorCode;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("offset")
  @Override
  public long getOffset() {
    return offset;
  }

  @JsonProperty("timestamp")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Instant> getTimestamp() {
    return timestamp;
  }

  @JsonProperty("key")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<ProduceResponse.ProduceResponseData> getKey() {
    return key;
  }

  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<ProduceResponse.ProduceResponseData> getValue() {
    return value;
  }

  @Override
  public String toString() {
    return "ProduceResponse{"
        + "errorCode=" + errorCode + ", "
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "offset=" + offset + ", "
        + "timestamp=" + timestamp + ", "
        + "key=" + key + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceResponse) {
      ProduceResponse that = (ProduceResponse) o;
      return this.errorCode == that.getErrorCode()
          && this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.offset == that.getOffset()
          && this.timestamp.equals(that.getTimestamp())
          && this.key.equals(that.getKey())
          && this.value.equals(that.getValue());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= errorCode;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= (int) ((offset >>> 32) ^ offset);
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  static final class Builder extends ProduceResponse.Builder {
    private Integer errorCode;
    private String clusterId;
    private String topicName;
    private Integer partitionId;
    private Long offset;
    private Optional<Instant> timestamp = Optional.empty();
    private Optional<ProduceResponse.ProduceResponseData> key = Optional.empty();
    private Optional<ProduceResponse.ProduceResponseData> value = Optional.empty();
    Builder() {
    }
    @Override
    public ProduceResponse.Builder setErrorCode(int errorCode) {
      this.errorCode = errorCode;
      return this;
    }
    @Override
    public ProduceResponse.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ProduceResponse.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ProduceResponse.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ProduceResponse.Builder setOffset(long offset) {
      this.offset = offset;
      return this;
    }
    @Override
    public ProduceResponse.Builder setTimestamp(Optional<Instant> timestamp) {
      if (timestamp == null) {
        throw new NullPointerException("Null timestamp");
      }
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public ProduceResponse.Builder setTimestamp(@Nullable Instant timestamp) {
      this.timestamp = Optional.ofNullable(timestamp);
      return this;
    }
    @Override
    public ProduceResponse.Builder setKey(Optional<ProduceResponse.ProduceResponseData> key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    public ProduceResponse.Builder setKey(@Nullable ProduceResponse.ProduceResponseData key) {
      this.key = Optional.ofNullable(key);
      return this;
    }
    @Override
    public ProduceResponse.Builder setValue(Optional<ProduceResponse.ProduceResponseData> value) {
      if (value == null) {
        throw new NullPointerException("Null value");
      }
      this.value = value;
      return this;
    }
    @Override
    public ProduceResponse.Builder setValue(@Nullable ProduceResponse.ProduceResponseData value) {
      this.value = Optional.ofNullable(value);
      return this;
    }
    @Override
    public ProduceResponse build() {
      String missing = "";
      if (this.errorCode == null) {
        missing += " errorCode";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.offset == null) {
        missing += " offset";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProduceResponse(
          this.errorCode,
          this.clusterId,
          this.topicName,
          this.partitionId,
          this.offset,
          this.timestamp,
          this.key,
          this.value);
    }
  }

}
