package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceRequest_ProduceRequestData extends ProduceRequest.ProduceRequestData {

  private final Optional<EmbeddedFormat> format;

  private final Optional<String> subject;

  private final Optional<ProduceRequest.EnumSubjectNameStrategy> subjectNameStrategy;

  private final Optional<Integer> schemaId;

  private final Optional<Integer> schemaVersion;

  private final Optional<String> rawSchema;

  private final JsonNode data;

  private AutoValue_ProduceRequest_ProduceRequestData(
      Optional<EmbeddedFormat> format,
      Optional<String> subject,
      Optional<ProduceRequest.EnumSubjectNameStrategy> subjectNameStrategy,
      Optional<Integer> schemaId,
      Optional<Integer> schemaVersion,
      Optional<String> rawSchema,
      JsonNode data) {
    this.format = format;
    this.subject = subject;
    this.subjectNameStrategy = subjectNameStrategy;
    this.schemaId = schemaId;
    this.schemaVersion = schemaVersion;
    this.rawSchema = rawSchema;
    this.data = data;
  }

  @JsonProperty("type")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<EmbeddedFormat> getFormat() {
    return format;
  }

  @JsonProperty("subject")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<String> getSubject() {
    return subject;
  }

  @JsonProperty("subject_name_strategy")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<ProduceRequest.EnumSubjectNameStrategy> getSubjectNameStrategy() {
    return subjectNameStrategy;
  }

  @JsonProperty("schema_id")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Integer> getSchemaId() {
    return schemaId;
  }

  @JsonProperty("schema_version")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Integer> getSchemaVersion() {
    return schemaVersion;
  }

  @JsonProperty("schema")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<String> getRawSchema() {
    return rawSchema;
  }

  @JsonProperty("data")
  @Override
  public JsonNode getData() {
    return data;
  }

  @Override
  public String toString() {
    return "ProduceRequestData{"
        + "format=" + format + ", "
        + "subject=" + subject + ", "
        + "subjectNameStrategy=" + subjectNameStrategy + ", "
        + "schemaId=" + schemaId + ", "
        + "schemaVersion=" + schemaVersion + ", "
        + "rawSchema=" + rawSchema + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceRequest.ProduceRequestData) {
      ProduceRequest.ProduceRequestData that = (ProduceRequest.ProduceRequestData) o;
      return this.format.equals(that.getFormat())
          && this.subject.equals(that.getSubject())
          && this.subjectNameStrategy.equals(that.getSubjectNameStrategy())
          && this.schemaId.equals(that.getSchemaId())
          && this.schemaVersion.equals(that.getSchemaVersion())
          && this.rawSchema.equals(that.getRawSchema())
          && this.data.equals(that.getData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= format.hashCode();
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= subjectNameStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= schemaId.hashCode();
    h$ *= 1000003;
    h$ ^= schemaVersion.hashCode();
    h$ *= 1000003;
    h$ ^= rawSchema.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  static final class Builder extends ProduceRequest.ProduceRequestData.Builder {
    private Optional<EmbeddedFormat> format = Optional.empty();
    private Optional<String> subject = Optional.empty();
    private Optional<ProduceRequest.EnumSubjectNameStrategy> subjectNameStrategy = Optional.empty();
    private Optional<Integer> schemaId = Optional.empty();
    private Optional<Integer> schemaVersion = Optional.empty();
    private Optional<String> rawSchema = Optional.empty();
    private JsonNode data;
    Builder() {
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setFormat(@Nullable EmbeddedFormat format) {
      this.format = Optional.ofNullable(format);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setSubject(@Nullable String subject) {
      this.subject = Optional.ofNullable(subject);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setSubjectNameStrategy(@Nullable ProduceRequest.EnumSubjectNameStrategy subjectNameStrategy) {
      this.subjectNameStrategy = Optional.ofNullable(subjectNameStrategy);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setSchemaId(@Nullable Integer schemaId) {
      this.schemaId = Optional.ofNullable(schemaId);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setSchemaVersion(@Nullable Integer schemaVersion) {
      this.schemaVersion = Optional.ofNullable(schemaVersion);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setRawSchema(@Nullable String rawSchema) {
      this.rawSchema = Optional.ofNullable(rawSchema);
      return this;
    }
    @Override
    public ProduceRequest.ProduceRequestData.Builder setData(JsonNode data) {
      if (data == null) {
        throw new NullPointerException("Null data");
      }
      this.data = data;
      return this;
    }
    @Override
    ProduceRequest.ProduceRequestData autoBuild() {
      String missing = "";
      if (this.data == null) {
        missing += " data";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProduceRequest_ProduceRequestData(
          this.format,
          this.subject,
          this.subjectNameStrategy,
          this.schemaId,
          this.schemaVersion,
          this.rawSchema,
          this.data);
    }
  }

}
