package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceRequest extends ProduceRequest {

  private final Optional<Integer> partitionId;

  private final ImmutableList<ProduceRequest.ProduceRequestHeader> headers;

  private final Optional<ProduceRequest.ProduceRequestData> key;

  private final Optional<ProduceRequest.ProduceRequestData> value;

  private final Optional<Instant> timestamp;

  private final long originalSize;

  private AutoValue_ProduceRequest(
      Optional<Integer> partitionId,
      ImmutableList<ProduceRequest.ProduceRequestHeader> headers,
      Optional<ProduceRequest.ProduceRequestData> key,
      Optional<ProduceRequest.ProduceRequestData> value,
      Optional<Instant> timestamp,
      long originalSize) {
    this.partitionId = partitionId;
    this.headers = headers;
    this.key = key;
    this.value = value;
    this.timestamp = timestamp;
    this.originalSize = originalSize;
  }

  @JsonProperty("partition_id")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Integer> getPartitionId() {
    return partitionId;
  }

  @JsonProperty("headers")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public ImmutableList<ProduceRequest.ProduceRequestHeader> getHeaders() {
    return headers;
  }

  @JsonProperty("key")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<ProduceRequest.ProduceRequestData> getKey() {
    return key;
  }

  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<ProduceRequest.ProduceRequestData> getValue() {
    return value;
  }

  @JsonProperty("timestamp")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Instant> getTimestamp() {
    return timestamp;
  }

  @JsonIgnore
  @Override
  public long getOriginalSize() {
    return originalSize;
  }

  @Override
  public String toString() {
    return "ProduceRequest{"
        + "partitionId=" + partitionId + ", "
        + "headers=" + headers + ", "
        + "key=" + key + ", "
        + "value=" + value + ", "
        + "timestamp=" + timestamp + ", "
        + "originalSize=" + originalSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceRequest) {
      ProduceRequest that = (ProduceRequest) o;
      return this.partitionId.equals(that.getPartitionId())
          && this.headers.equals(that.getHeaders())
          && this.key.equals(that.getKey())
          && this.value.equals(that.getValue())
          && this.timestamp.equals(that.getTimestamp())
          && this.originalSize == that.getOriginalSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= partitionId.hashCode();
    h$ *= 1000003;
    h$ ^= headers.hashCode();
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((originalSize >>> 32) ^ originalSize);
    return h$;
  }

  static final class Builder extends ProduceRequest.Builder {
    private Optional<Integer> partitionId = Optional.empty();
    private ImmutableList<ProduceRequest.ProduceRequestHeader> headers;
    private Optional<ProduceRequest.ProduceRequestData> key = Optional.empty();
    private Optional<ProduceRequest.ProduceRequestData> value = Optional.empty();
    private Optional<Instant> timestamp = Optional.empty();
    private Long originalSize;
    Builder() {
    }
    @Override
    public ProduceRequest.Builder setPartitionId(@Nullable Integer partitionId) {
      this.partitionId = Optional.ofNullable(partitionId);
      return this;
    }
    @Override
    public ProduceRequest.Builder setHeaders(List<ProduceRequest.ProduceRequestHeader> headers) {
      this.headers = ImmutableList.copyOf(headers);
      return this;
    }
    @Override
    public ProduceRequest.Builder setKey(@Nullable ProduceRequest.ProduceRequestData key) {
      this.key = Optional.ofNullable(key);
      return this;
    }
    @Override
    public ProduceRequest.Builder setValue(@Nullable ProduceRequest.ProduceRequestData value) {
      this.value = Optional.ofNullable(value);
      return this;
    }
    @Override
    public ProduceRequest.Builder setTimestamp(@Nullable Instant timestamp) {
      this.timestamp = Optional.ofNullable(timestamp);
      return this;
    }
    @Override
    public ProduceRequest.Builder setOriginalSize(long originalSize) {
      this.originalSize = originalSize;
      return this;
    }
    @Override
    public ProduceRequest build() {
      String missing = "";
      if (this.headers == null) {
        missing += " headers";
      }
      if (this.originalSize == null) {
        missing += " originalSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProduceRequest(
          this.partitionId,
          this.headers,
          this.key,
          this.value,
          this.timestamp,
          this.originalSize);
    }
  }

}
