package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PartitionData extends PartitionData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final Optional<Resource.Relationship> leader;

  private final Resource.Relationship replicas;

  private final Resource.Relationship reassignment;

  private AutoValue_PartitionData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String topicName,
      int partitionId,
      Optional<Resource.Relationship> leader,
      Resource.Relationship replicas,
      Resource.Relationship reassignment) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.leader = leader;
    this.replicas = replicas;
    this.reassignment = reassignment;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("leader")
  @Override
  public Optional<Resource.Relationship> getLeader() {
    return leader;
  }

  @JsonProperty("replicas")
  @Override
  public Resource.Relationship getReplicas() {
    return replicas;
  }

  @JsonProperty("reassignment")
  @Override
  public Resource.Relationship getReassignment() {
    return reassignment;
  }

  @Override
  public String toString() {
    return "PartitionData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "leader=" + leader + ", "
        + "replicas=" + replicas + ", "
        + "reassignment=" + reassignment
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PartitionData) {
      PartitionData that = (PartitionData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.leader.equals(that.getLeader())
          && this.replicas.equals(that.getReplicas())
          && this.reassignment.equals(that.getReassignment());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= leader.hashCode();
    h$ *= 1000003;
    h$ ^= replicas.hashCode();
    h$ *= 1000003;
    h$ ^= reassignment.hashCode();
    return h$;
  }

  static final class Builder extends PartitionData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String topicName;
    private Integer partitionId;
    private Optional<Resource.Relationship> leader = Optional.empty();
    private Resource.Relationship replicas;
    private Resource.Relationship reassignment;
    Builder() {
    }
    @Override
    public PartitionData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public PartitionData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public PartitionData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public PartitionData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public PartitionData.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public PartitionData.Builder setLeader(@Nullable Resource.Relationship leader) {
      this.leader = Optional.ofNullable(leader);
      return this;
    }
    @Override
    public PartitionData.Builder setReplicas(Resource.Relationship replicas) {
      if (replicas == null) {
        throw new NullPointerException("Null replicas");
      }
      this.replicas = replicas;
      return this;
    }
    @Override
    public PartitionData.Builder setReassignment(Resource.Relationship reassignment) {
      if (reassignment == null) {
        throw new NullPointerException("Null reassignment");
      }
      this.reassignment = reassignment;
      return this;
    }
    @Override
    public PartitionData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.replicas == null) {
        missing += " replicas";
      }
      if (this.reassignment == null) {
        missing += " reassignment";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PartitionData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.topicName,
          this.partitionId,
          this.leader,
          this.replicas,
          this.reassignment);
    }
  }

}
