package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CreateTopicRequest extends CreateTopicRequest {

  private final String topicName;

  private final Optional<Integer> partitionsCount;

  private final Optional<Short> replicationFactor;

  private final Map<Integer, List<Integer>> replicasAssignments;

  private final ImmutableList<CreateTopicRequest.ConfigEntry> configs;

  private AutoValue_CreateTopicRequest(
      String topicName,
      Optional<Integer> partitionsCount,
      Optional<Short> replicationFactor,
      Map<Integer, List<Integer>> replicasAssignments,
      ImmutableList<CreateTopicRequest.ConfigEntry> configs) {
    this.topicName = topicName;
    this.partitionsCount = partitionsCount;
    this.replicationFactor = replicationFactor;
    this.replicasAssignments = replicasAssignments;
    this.configs = configs;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partitions_count")
  @Override
  public Optional<Integer> getPartitionsCount() {
    return partitionsCount;
  }

  @JsonProperty("replication_factor")
  @Override
  public Optional<Short> getReplicationFactor() {
    return replicationFactor;
  }

  @JsonProperty("replicas_assignments")
  @Override
  public Map<Integer, List<Integer>> getReplicasAssignments() {
    return replicasAssignments;
  }

  @JsonProperty("configs")
  @Override
  public ImmutableList<CreateTopicRequest.ConfigEntry> getConfigs() {
    return configs;
  }

  @Override
  public String toString() {
    return "CreateTopicRequest{"
        + "topicName=" + topicName + ", "
        + "partitionsCount=" + partitionsCount + ", "
        + "replicationFactor=" + replicationFactor + ", "
        + "replicasAssignments=" + replicasAssignments + ", "
        + "configs=" + configs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateTopicRequest) {
      CreateTopicRequest that = (CreateTopicRequest) o;
      return this.topicName.equals(that.getTopicName())
          && this.partitionsCount.equals(that.getPartitionsCount())
          && this.replicationFactor.equals(that.getReplicationFactor())
          && this.replicasAssignments.equals(that.getReplicasAssignments())
          && this.configs.equals(that.getConfigs());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionsCount.hashCode();
    h$ *= 1000003;
    h$ ^= replicationFactor.hashCode();
    h$ *= 1000003;
    h$ ^= replicasAssignments.hashCode();
    h$ *= 1000003;
    h$ ^= configs.hashCode();
    return h$;
  }

  static final class Builder extends CreateTopicRequest.Builder {
    private String topicName;
    private Optional<Integer> partitionsCount = Optional.empty();
    private Optional<Short> replicationFactor = Optional.empty();
    private Map<Integer, List<Integer>> replicasAssignments;
    private ImmutableList<CreateTopicRequest.ConfigEntry> configs;
    Builder() {
    }
    @Override
    public CreateTopicRequest.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public CreateTopicRequest.Builder setPartitionsCount(@Nullable Integer partitionsCount) {
      this.partitionsCount = Optional.ofNullable(partitionsCount);
      return this;
    }
    @Override
    public CreateTopicRequest.Builder setReplicationFactor(@Nullable Short replicationFactor) {
      this.replicationFactor = Optional.ofNullable(replicationFactor);
      return this;
    }
    @Override
    public CreateTopicRequest.Builder setReplicasAssignments(Map<Integer, List<Integer>> replicasAssignments) {
      if (replicasAssignments == null) {
        throw new NullPointerException("Null replicasAssignments");
      }
      this.replicasAssignments = replicasAssignments;
      return this;
    }
    @Override
    public CreateTopicRequest.Builder setConfigs(List<CreateTopicRequest.ConfigEntry> configs) {
      this.configs = ImmutableList.copyOf(configs);
      return this;
    }
    @Override
    public CreateTopicRequest build() {
      String missing = "";
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.replicasAssignments == null) {
        missing += " replicasAssignments";
      }
      if (this.configs == null) {
        missing += " configs";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CreateTopicRequest(
          this.topicName,
          this.partitionsCount,
          this.replicationFactor,
          this.replicasAssignments,
          this.configs);
    }
  }

}
