package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerLagDataList extends ConsumerLagDataList {

  private final String kind;

  private final ResourceCollection.Metadata metadata;

  private final ImmutableList<ConsumerLagData> data;

  private AutoValue_ConsumerLagDataList(
      String kind,
      ResourceCollection.Metadata metadata,
      ImmutableList<ConsumerLagData> data) {
    this.kind = kind;
    this.metadata = metadata;
    this.data = data;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public ResourceCollection.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("data")
  @Override
  public ImmutableList<ConsumerLagData> getData() {
    return data;
  }

  @Override
  public String toString() {
    return "ConsumerLagDataList{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerLagDataList) {
      ConsumerLagDataList that = (ConsumerLagDataList) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.data.equals(that.getData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerLagDataList.Builder {
    private String kind;
    private ResourceCollection.Metadata metadata;
    private ImmutableList<ConsumerLagData> data;
    Builder() {
    }
    @Override
    public ConsumerLagDataList.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerLagDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerLagDataList.Builder setData(List<ConsumerLagData> data) {
      this.data = ImmutableList.copyOf(data);
      return this;
    }
    @Override
    public ConsumerLagDataList build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.data == null) {
        missing += " data";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerLagDataList(
          this.kind,
          this.metadata,
          this.data);
    }
  }

}
