package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerLagData extends ConsumerLagData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String consumerGroupId;

  private final String topicName;

  private final int partitionId;

  private final String consumerId;

  private final Optional<String> instanceId;

  private final String clientId;

  private final Long currentOffset;

  private final Long logEndOffset;

  private final Long lag;

  private AutoValue_ConsumerLagData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String consumerGroupId,
      String topicName,
      int partitionId,
      String consumerId,
      Optional<String> instanceId,
      String clientId,
      Long currentOffset,
      Long logEndOffset,
      Long lag) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.consumerId = consumerId;
    this.instanceId = instanceId;
    this.clientId = clientId;
    this.currentOffset = currentOffset;
    this.logEndOffset = logEndOffset;
    this.lag = lag;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("consumer_group_id")
  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("consumer_id")
  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @JsonProperty("instance_id")
  @Override
  public Optional<String> getInstanceId() {
    return instanceId;
  }

  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  @JsonProperty("current_offset")
  @Override
  public Long getCurrentOffset() {
    return currentOffset;
  }

  @JsonProperty("log_end_offset")
  @Override
  public Long getLogEndOffset() {
    return logEndOffset;
  }

  @JsonProperty("lag")
  @Override
  public Long getLag() {
    return lag;
  }

  @Override
  public String toString() {
    return "ConsumerLagData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "consumerId=" + consumerId + ", "
        + "instanceId=" + instanceId + ", "
        + "clientId=" + clientId + ", "
        + "currentOffset=" + currentOffset + ", "
        + "logEndOffset=" + logEndOffset + ", "
        + "lag=" + lag
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerLagData) {
      ConsumerLagData that = (ConsumerLagData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.consumerId.equals(that.getConsumerId())
          && this.instanceId.equals(that.getInstanceId())
          && this.clientId.equals(that.getClientId())
          && this.currentOffset.equals(that.getCurrentOffset())
          && this.logEndOffset.equals(that.getLogEndOffset())
          && this.lag.equals(that.getLag());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= instanceId.hashCode();
    h$ *= 1000003;
    h$ ^= clientId.hashCode();
    h$ *= 1000003;
    h$ ^= currentOffset.hashCode();
    h$ *= 1000003;
    h$ ^= logEndOffset.hashCode();
    h$ *= 1000003;
    h$ ^= lag.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerLagData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String consumerGroupId;
    private String topicName;
    private Integer partitionId;
    private String consumerId;
    private Optional<String> instanceId = Optional.empty();
    private String clientId;
    private Long currentOffset;
    private Long logEndOffset;
    private Long lag;
    Builder() {
    }
    @Override
    public ConsumerLagData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setInstanceId(@Nullable String instanceId) {
      this.instanceId = Optional.ofNullable(instanceId);
      return this;
    }
    @Override
    public ConsumerLagData.Builder setClientId(String clientId) {
      if (clientId == null) {
        throw new NullPointerException("Null clientId");
      }
      this.clientId = clientId;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setCurrentOffset(Long currentOffset) {
      if (currentOffset == null) {
        throw new NullPointerException("Null currentOffset");
      }
      this.currentOffset = currentOffset;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setLogEndOffset(Long logEndOffset) {
      if (logEndOffset == null) {
        throw new NullPointerException("Null logEndOffset");
      }
      this.logEndOffset = logEndOffset;
      return this;
    }
    @Override
    public ConsumerLagData.Builder setLag(Long lag) {
      if (lag == null) {
        throw new NullPointerException("Null lag");
      }
      this.lag = lag;
      return this;
    }
    @Override
    public ConsumerLagData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.clientId == null) {
        missing += " clientId";
      }
      if (this.currentOffset == null) {
        missing += " currentOffset";
      }
      if (this.logEndOffset == null) {
        missing += " logEndOffset";
      }
      if (this.lag == null) {
        missing += " lag";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerLagData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.consumerGroupId,
          this.topicName,
          this.partitionId,
          this.consumerId,
          this.instanceId,
          this.clientId,
          this.currentOffset,
          this.logEndOffset,
          this.lag);
    }
  }

}
