package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerGroupLagSummaryData extends ConsumerGroupLagSummaryData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String consumerGroupId;

  private final Long maxLag;

  private final Long totalLag;

  private final String maxLagConsumerId;

  private final Resource.Relationship maxLagConsumer;

  private final String maxLagClientId;

  private final Optional<String> maxLagInstanceId;

  private final String maxLagTopicName;

  private final Integer maxLagPartitionId;

  private final Resource.Relationship maxLagPartition;

  private AutoValue_ConsumerGroupLagSummaryData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String consumerGroupId,
      Long maxLag,
      Long totalLag,
      String maxLagConsumerId,
      Resource.Relationship maxLagConsumer,
      String maxLagClientId,
      Optional<String> maxLagInstanceId,
      String maxLagTopicName,
      Integer maxLagPartitionId,
      Resource.Relationship maxLagPartition) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.maxLag = maxLag;
    this.totalLag = totalLag;
    this.maxLagConsumerId = maxLagConsumerId;
    this.maxLagConsumer = maxLagConsumer;
    this.maxLagClientId = maxLagClientId;
    this.maxLagInstanceId = maxLagInstanceId;
    this.maxLagTopicName = maxLagTopicName;
    this.maxLagPartitionId = maxLagPartitionId;
    this.maxLagPartition = maxLagPartition;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("consumer_group_id")
  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @JsonProperty("max_lag")
  @Override
  public Long getMaxLag() {
    return maxLag;
  }

  @JsonProperty("total_lag")
  @Override
  public Long getTotalLag() {
    return totalLag;
  }

  @JsonProperty("max_lag_consumer_id")
  @Override
  public String getMaxLagConsumerId() {
    return maxLagConsumerId;
  }

  @JsonProperty("max_lag_consumer")
  @Override
  public Resource.Relationship getMaxLagConsumer() {
    return maxLagConsumer;
  }

  @JsonProperty("max_lag_client_id")
  @Override
  public String getMaxLagClientId() {
    return maxLagClientId;
  }

  @JsonProperty("max_lag_instance_id")
  @Override
  public Optional<String> getMaxLagInstanceId() {
    return maxLagInstanceId;
  }

  @JsonProperty("max_lag_topic_name")
  @Override
  public String getMaxLagTopicName() {
    return maxLagTopicName;
  }

  @JsonProperty("max_lag_partition_id")
  @Override
  public Integer getMaxLagPartitionId() {
    return maxLagPartitionId;
  }

  @JsonProperty("max_lag_partition")
  @Override
  public Resource.Relationship getMaxLagPartition() {
    return maxLagPartition;
  }

  @Override
  public String toString() {
    return "ConsumerGroupLagSummaryData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "maxLag=" + maxLag + ", "
        + "totalLag=" + totalLag + ", "
        + "maxLagConsumerId=" + maxLagConsumerId + ", "
        + "maxLagConsumer=" + maxLagConsumer + ", "
        + "maxLagClientId=" + maxLagClientId + ", "
        + "maxLagInstanceId=" + maxLagInstanceId + ", "
        + "maxLagTopicName=" + maxLagTopicName + ", "
        + "maxLagPartitionId=" + maxLagPartitionId + ", "
        + "maxLagPartition=" + maxLagPartition
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerGroupLagSummaryData) {
      ConsumerGroupLagSummaryData that = (ConsumerGroupLagSummaryData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.maxLag.equals(that.getMaxLag())
          && this.totalLag.equals(that.getTotalLag())
          && this.maxLagConsumerId.equals(that.getMaxLagConsumerId())
          && this.maxLagConsumer.equals(that.getMaxLagConsumer())
          && this.maxLagClientId.equals(that.getMaxLagClientId())
          && this.maxLagInstanceId.equals(that.getMaxLagInstanceId())
          && this.maxLagTopicName.equals(that.getMaxLagTopicName())
          && this.maxLagPartitionId.equals(that.getMaxLagPartitionId())
          && this.maxLagPartition.equals(that.getMaxLagPartition());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= maxLag.hashCode();
    h$ *= 1000003;
    h$ ^= totalLag.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagConsumerId.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagConsumer.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagClientId.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagInstanceId.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagTopicName.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagPartitionId.hashCode();
    h$ *= 1000003;
    h$ ^= maxLagPartition.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerGroupLagSummaryData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String consumerGroupId;
    private Long maxLag;
    private Long totalLag;
    private String maxLagConsumerId;
    private Resource.Relationship maxLagConsumer;
    private String maxLagClientId;
    private Optional<String> maxLagInstanceId = Optional.empty();
    private String maxLagTopicName;
    private Integer maxLagPartitionId;
    private Resource.Relationship maxLagPartition;
    Builder() {
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLag(Long maxLag) {
      if (maxLag == null) {
        throw new NullPointerException("Null maxLag");
      }
      this.maxLag = maxLag;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setTotalLag(Long totalLag) {
      if (totalLag == null) {
        throw new NullPointerException("Null totalLag");
      }
      this.totalLag = totalLag;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagConsumerId(String maxLagConsumerId) {
      if (maxLagConsumerId == null) {
        throw new NullPointerException("Null maxLagConsumerId");
      }
      this.maxLagConsumerId = maxLagConsumerId;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagConsumer(Resource.Relationship maxLagConsumer) {
      if (maxLagConsumer == null) {
        throw new NullPointerException("Null maxLagConsumer");
      }
      this.maxLagConsumer = maxLagConsumer;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagClientId(String maxLagClientId) {
      if (maxLagClientId == null) {
        throw new NullPointerException("Null maxLagClientId");
      }
      this.maxLagClientId = maxLagClientId;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagInstanceId(@Nullable String maxLagInstanceId) {
      this.maxLagInstanceId = Optional.ofNullable(maxLagInstanceId);
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagTopicName(String maxLagTopicName) {
      if (maxLagTopicName == null) {
        throw new NullPointerException("Null maxLagTopicName");
      }
      this.maxLagTopicName = maxLagTopicName;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagPartitionId(Integer maxLagPartitionId) {
      if (maxLagPartitionId == null) {
        throw new NullPointerException("Null maxLagPartitionId");
      }
      this.maxLagPartitionId = maxLagPartitionId;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData.Builder setMaxLagPartition(Resource.Relationship maxLagPartition) {
      if (maxLagPartition == null) {
        throw new NullPointerException("Null maxLagPartition");
      }
      this.maxLagPartition = maxLagPartition;
      return this;
    }
    @Override
    public ConsumerGroupLagSummaryData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.maxLag == null) {
        missing += " maxLag";
      }
      if (this.totalLag == null) {
        missing += " totalLag";
      }
      if (this.maxLagConsumerId == null) {
        missing += " maxLagConsumerId";
      }
      if (this.maxLagConsumer == null) {
        missing += " maxLagConsumer";
      }
      if (this.maxLagClientId == null) {
        missing += " maxLagClientId";
      }
      if (this.maxLagTopicName == null) {
        missing += " maxLagTopicName";
      }
      if (this.maxLagPartitionId == null) {
        missing += " maxLagPartitionId";
      }
      if (this.maxLagPartition == null) {
        missing += " maxLagPartition";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerGroupLagSummaryData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.consumerGroupId,
          this.maxLag,
          this.totalLag,
          this.maxLagConsumerId,
          this.maxLagConsumer,
          this.maxLagClientId,
          this.maxLagInstanceId,
          this.maxLagTopicName,
          this.maxLagPartitionId,
          this.maxLagPartition);
    }
  }

}
