package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ConsumerGroup;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerGroupData extends ConsumerGroupData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String consumerGroupId;

  private final boolean simple;

  private final String partitionAssignor;

  private final ConsumerGroup.State state;

  private final Resource.Relationship coordinator;

  private final Resource.Relationship consumers;

  private final Resource.Relationship lagSummary;

  private AutoValue_ConsumerGroupData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String consumerGroupId,
      boolean simple,
      String partitionAssignor,
      ConsumerGroup.State state,
      Resource.Relationship coordinator,
      Resource.Relationship consumers,
      Resource.Relationship lagSummary) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.simple = simple;
    this.partitionAssignor = partitionAssignor;
    this.state = state;
    this.coordinator = coordinator;
    this.consumers = consumers;
    this.lagSummary = lagSummary;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("consumer_group_id")
  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @JsonProperty("is_simple")
  @Override
  public boolean isSimple() {
    return simple;
  }

  @JsonProperty("partition_assignor")
  @Override
  public String getPartitionAssignor() {
    return partitionAssignor;
  }

  @JsonProperty("state")
  @Override
  public ConsumerGroup.State getState() {
    return state;
  }

  @JsonProperty("coordinator")
  @Override
  public Resource.Relationship getCoordinator() {
    return coordinator;
  }

  @JsonProperty("consumers")
  @Override
  public Resource.Relationship getConsumers() {
    return consumers;
  }

  @JsonProperty("lag_summary")
  @Override
  public Resource.Relationship getLagSummary() {
    return lagSummary;
  }

  @Override
  public String toString() {
    return "ConsumerGroupData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "simple=" + simple + ", "
        + "partitionAssignor=" + partitionAssignor + ", "
        + "state=" + state + ", "
        + "coordinator=" + coordinator + ", "
        + "consumers=" + consumers + ", "
        + "lagSummary=" + lagSummary
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerGroupData) {
      ConsumerGroupData that = (ConsumerGroupData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.simple == that.isSimple()
          && this.partitionAssignor.equals(that.getPartitionAssignor())
          && this.state.equals(that.getState())
          && this.coordinator.equals(that.getCoordinator())
          && this.consumers.equals(that.getConsumers())
          && this.lagSummary.equals(that.getLagSummary());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= simple ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= partitionAssignor.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    h$ *= 1000003;
    h$ ^= coordinator.hashCode();
    h$ *= 1000003;
    h$ ^= consumers.hashCode();
    h$ *= 1000003;
    h$ ^= lagSummary.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerGroupData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String consumerGroupId;
    private Boolean simple;
    private String partitionAssignor;
    private ConsumerGroup.State state;
    private Resource.Relationship coordinator;
    private Resource.Relationship consumers;
    private Resource.Relationship lagSummary;
    Builder() {
    }
    @Override
    public ConsumerGroupData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setSimple(boolean simple) {
      this.simple = simple;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setPartitionAssignor(String partitionAssignor) {
      if (partitionAssignor == null) {
        throw new NullPointerException("Null partitionAssignor");
      }
      this.partitionAssignor = partitionAssignor;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setState(ConsumerGroup.State state) {
      if (state == null) {
        throw new NullPointerException("Null state");
      }
      this.state = state;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setCoordinator(Resource.Relationship coordinator) {
      if (coordinator == null) {
        throw new NullPointerException("Null coordinator");
      }
      this.coordinator = coordinator;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setConsumers(Resource.Relationship consumers) {
      if (consumers == null) {
        throw new NullPointerException("Null consumers");
      }
      this.consumers = consumers;
      return this;
    }
    @Override
    public ConsumerGroupData.Builder setLagSummary(Resource.Relationship lagSummary) {
      if (lagSummary == null) {
        throw new NullPointerException("Null lagSummary");
      }
      this.lagSummary = lagSummary;
      return this;
    }
    @Override
    public ConsumerGroupData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.simple == null) {
        missing += " simple";
      }
      if (this.partitionAssignor == null) {
        missing += " partitionAssignor";
      }
      if (this.state == null) {
        missing += " state";
      }
      if (this.coordinator == null) {
        missing += " coordinator";
      }
      if (this.consumers == null) {
        missing += " consumers";
      }
      if (this.lagSummary == null) {
        missing += " lagSummary";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerGroupData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.consumerGroupId,
          this.simple,
          this.partitionAssignor,
          this.state,
          this.coordinator,
          this.consumers,
          this.lagSummary);
    }
  }

}
